/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.jaeger.runtime;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.opentelemetry.exporter.internal.TlsUtil;
import io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

final class JaegerSubstitutions {
    JaegerSubstitutions() {
    }

    @TargetClass(value=ManagedChannelUtil.class)
    static final class Target_ManagedChannelUtil {
        Target_ManagedChannelUtil() {
        }

        @Substitute
        public static void setClientKeysAndTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] privateKeyPem, byte[] certificatePem, byte[] trustedCertificatesPem) throws SSLException {
            Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
            Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
            X509TrustManager tm = TlsUtil.trustManager((byte[])trustedCertificatesPem);
            if (!managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
                throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
            }
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager((TrustManager)tm).build());
        }
    }
}

