/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.otlp.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.opentelemetry.exporter.otlp.runtime.OtlpExporterConfig;
import io.quarkus.opentelemetry.exporter.otlp.runtime.OtlpExporterProvider;
import io.quarkus.opentelemetry.exporter.otlp.runtime.OtlpRecorder;
import java.util.function.BooleanSupplier;

@BuildSteps(onlyIf={OtlpExporterEnabled.class})
public class OtlpExporterProcessor {
    @BuildStep
    AdditionalBeanBuildItem createBatchSpanProcessor() {
        return AdditionalBeanBuildItem.builder().addBeanClass(OtlpExporterProvider.class).setUnremovable().build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void installBatchSpanProcessorForOtlp(OtlpRecorder recorder, LaunchModeBuildItem launchModeBuildItem, OtlpExporterConfig.OtlpExporterRuntimeConfig runtimeConfig) {
        recorder.installBatchSpanProcessorForOtlp(runtimeConfig, launchModeBuildItem.getLaunchMode());
    }

    static class OtlpExporterEnabled
    implements BooleanSupplier {
        OtlpExporterConfig.OtlpExporterBuildConfig otlpExporterConfig;

        OtlpExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otlpExporterConfig.enabled;
        }
    }
}

