/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.otlp.runtime;

import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.opentelemetry.exporter.otlp.runtime.LateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.exporter.otlp.runtime.OtlpExporterConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class OtlpRecorder {
    public void installBatchSpanProcessorForOtlp(OtlpExporterConfig.OtlpExporterRuntimeConfig runtimeConfig, LaunchMode launchMode) {
        if (launchMode == LaunchMode.DEVELOPMENT && !runtimeConfig.endpoint.isPresent()) {
            runtimeConfig.endpoint = Optional.of("http://localhost:4317");
        }
        if (runtimeConfig.endpoint.isPresent() && runtimeConfig.endpoint.get().trim().length() > 0) {
            try {
                OtlpGrpcSpanExporter otlpSpanExporter = OtlpGrpcSpanExporter.builder().setEndpoint(runtimeConfig.endpoint.get()).setTimeout(runtimeConfig.exportTimeout).build();
                LateBoundBatchSpanProcessor delayedProcessor = (LateBoundBatchSpanProcessor)CDI.current().select(LateBoundBatchSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
                delayedProcessor.setBatchSpanProcessorDelegate(BatchSpanProcessor.builder((SpanExporter)otlpSpanExporter).build());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Unable to install OTLP Exporter", iae);
            }
        }
    }
}

