/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.otlp.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

@TargetClass(className="io.opentelemetry.exporter.otlp.internal.grpc.ManagedChannelUtil")
final class Target_io_opentelemetry_exporter_otlp_internal_grpc_ManagedChannelUtil {
    Target_io_opentelemetry_exporter_otlp_internal_grpc_ManagedChannelUtil() {
    }

    @Substitute
    public static void setTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        TrustManagerFactory tmf = Target_io_opentelemetry_exporter_otlp_internal_grpc_ManagedChannelUtil.trustManagerFactory(trustedCertificatesPem);
        if (!managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
        NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
        nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager(tmf).build());
    }

    @Alias
    private static TrustManagerFactory trustManagerFactory(byte[] trustedCertificatesPem) throws SSLException {
        return null;
    }
}

