/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class OpenTelemetryContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        Context capturedContext = Context.current();
        return () -> {
            Context context = Context.current();
            if (capturedContext != context) {
                capturedContext.makeCurrent();
            }
            return () -> {
                if (Context.current() != context) {
                    context.makeCurrent();
                }
            };
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        return () -> {
            Scope emptyScope = Context.root().makeCurrent();
            return () -> ((Scope)emptyScope).close();
        };
    }

    public String getThreadContextType() {
        return "OpenTelemetry";
    }
}

