/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

public enum QuarkusContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger log;
    private static final String CONTEXT_KEY;
    private static final ThreadLocal<RoutingContext> THREAD_LOCAL_ROUTING_CONTEXT;

    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach || beforeAttach == Context.root()) {
            return NoopScope.INSTANCE;
        }
        RoutingContext routingContext = this.getRoutingContext();
        if (routingContext != null) {
            routingContext.put(CONTEXT_KEY, (Object)toAttach);
        } else {
            log.debug((Object)"RoutingContext not available. Unable to set new Context onto it.");
        }
        return () -> {
            if (routingContext != null) {
                routingContext.put(CONTEXT_KEY, (Object)beforeAttach);
            }
        };
    }

    public Context current() {
        RoutingContext routingContext = this.getRoutingContext();
        if (routingContext != null) {
            return (Context)routingContext.get(CONTEXT_KEY);
        }
        return null;
    }

    private RoutingContext getRoutingContext() {
        try {
            RoutingContext currentRoutingContext = ((CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent();
            THREAD_LOCAL_ROUTING_CONTEXT.remove();
            return currentRoutingContext;
        }
        catch (ContextNotActiveException cnae) {
            return THREAD_LOCAL_ROUTING_CONTEXT.get();
        }
    }

    public void setRoutingContext(RoutingContext internalRoutingContext) {
        THREAD_LOCAL_ROUTING_CONTEXT.set(internalRoutingContext);
    }

    public void clearRoutingContext(RoutingContext routingContext) {
        if (routingContext.equals(THREAD_LOCAL_ROUTING_CONTEXT.get())) {
            THREAD_LOCAL_ROUTING_CONTEXT.remove();
        }
    }

    static {
        log = Logger.getLogger(QuarkusContextStorage.class);
        CONTEXT_KEY = QuarkusContextStorage.class.getName() + ".activeContext";
        THREAD_LOCAL_ROUTING_CONTEXT = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        public void close() {
        }
    }
}

