/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;

@Recorder
public class TracerRecorder {
    public RuntimeValue<SdkTracerProvider> createTracerProvider(String serviceName, String serviceVersion, ShutdownContext shutdownContext) {
        BeanManager beanManager = Arc.container().beanManager();
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder();
        builder.setResource(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ResourceAttributes.SERVICE_VERSION, (Object)serviceVersion))));
        Instance allExporters = beanManager.createInstance().select(SpanExporter.class, new Annotation[]{Any.Literal.INSTANCE});
        allExporters.forEach(spanExporter -> builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)));
        Instance allProcessors = beanManager.createInstance().select(SpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE});
        allProcessors.forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        SdkTracerProvider tracerProvider = builder.build();
        shutdownContext.addShutdownTask(() -> {
            tracerProvider.forceFlush();
            tracerProvider.shutdown();
        });
        return new RuntimeValue((Object)tracerProvider);
    }
}

