/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.tracing.vertx;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.quarkus.opentelemetry.QuarkusContextStorage;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;

public class VertxTracerFilter
implements Handler<RoutingContext> {
    private static final TextMapPropagator TEXT_MAP_PROPAGATOR = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    Tracer tracer;
    boolean initialized = false;
    private static final TextMapGetter<HttpServerRequest> GETTER = new TextMapGetter<HttpServerRequest>(){

        public Iterable<String> keys(final HttpServerRequest carrier) {
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return carrier.headers().names().iterator();
                }
            };
        }

        public String get(HttpServerRequest carrier, String key) {
            if (carrier != null) {
                return carrier.getHeader(key);
            }
            return null;
        }
    };

    public void handle(final RoutingContext routingContext) {
        QuarkusContextStorage.INSTANCE.setRoutingContext(routingContext);
        if (!this.initialized) {
            Instance tracerInstance = CDI.current().select(Tracer.class, new Annotation[0]);
            if (tracerInstance.isResolvable()) {
                this.tracer = (Tracer)tracerInstance.get();
            }
            this.initialized = true;
        }
        if (this.tracer != null) {
            Context parentContext = this.propagatedContext(routingContext);
            SpanBuilder builder = this.tracer.spanBuilder(routingContext.request().uri().substring(1)).setParent(parentContext).setSpanKind(SpanKind.SERVER);
            builder.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)this.convertHttpVersion(routingContext.request().version()));
            builder.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)routingContext.request().method().name());
            builder.setAttribute(SemanticAttributes.HTTP_TARGET, (Object)routingContext.request().path());
            builder.setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)routingContext.request().scheme());
            builder.setAttribute(SemanticAttributes.HTTP_HOST, (Object)routingContext.request().host());
            builder.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)routingContext.request().remoteAddress().host());
            builder.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)routingContext.request().getHeader("User-Agent"));
            String contentLength = routingContext.request().getHeader("Content-Length");
            if (contentLength != null && contentLength.length() > 0 && Long.parseLong(contentLength) > 0L) {
                builder.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)Long.valueOf(contentLength));
            } else {
                builder.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)routingContext.request().bytesRead());
            }
            final Span currentSpan = builder.startSpan();
            final Scope spanScope = currentSpan.makeCurrent();
            final HttpServerResponse response = routingContext.response();
            routingContext.addHeadersEndHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    currentSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, response.getStatusCode());
                    if (routingContext.failed()) {
                        currentSpan.setStatus(StatusCode.ERROR);
                        currentSpan.recordException(routingContext.failure());
                    }
                    currentSpan.end();
                    spanScope.close();
                    QuarkusContextStorage.INSTANCE.clearRoutingContext(routingContext);
                }
            });
        }
        routingContext.next();
    }

    private String convertHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2: {
                return "2.0";
            }
        }
        return "";
    }

    private Context propagatedContext(RoutingContext routingContext) {
        return TEXT_MAP_PROPAGATOR.extract(Context.current(), (Object)routingContext.request(), GETTER);
    }
}

