/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.tracing.client;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;

@Priority(value=3000)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TextMapPropagator TEXT_MAP_PROPAGATOR = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    private Tracer tracer;
    private Span clientSpan;
    private static final TextMapSetter<MultivaluedMap<String, Object>> SETTER = new TextMapSetter<MultivaluedMap<String, Object>>(){

        public void set(MultivaluedMap<String, Object> carrier, String key, String value) {
            carrier.add((Object)key, (Object)value);
        }
    };

    public ClientTracingFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        SpanBuilder builder = this.tracer.spanBuilder(requestContext.getUri().getPath().substring(1)).setSpanKind(SpanKind.CLIENT);
        builder.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)((ClientRequestContextImpl)requestContext).getInvocation().getMethod());
        builder.setAttribute(SemanticAttributes.HTTP_URL, (Object)requestContext.getUri().toString());
        this.clientSpan = builder.startSpan();
        TEXT_MAP_PROPAGATOR.inject(Context.current().with((ImplicitContextKeyed)this.clientSpan), (Object)requestContext.getHeaders(), SETTER);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (this.clientSpan != null) {
            this.clientSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, responseContext.getStatus());
            if (!responseContext.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                this.clientSpan.setStatus(StatusCode.ERROR, responseContext.getStatusInfo().getReasonPhrase());
            }
            this.clientSpan.end();
        }
    }
}

