/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.dev;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.net.URL;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class OpenTelemetryDevServicesConfigBuilder
implements ConfigBuilder {
    public static final String OPENTELEMETRY_DEVSERVICES_CONFIG = "opentelemetry-devservices-config.properties";

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        builder.withSources((ConfigSourceProvider)new DevServicesConfigSourceFactory());
        return builder;
    }

    private static class DevServicesConfigSourceFactory
    extends AbstractLocationConfigSourceLoader
    implements ConfigSourceProvider {
        private DevServicesConfigSourceFactory() {
        }

        protected String[] getFileExtensions() {
            return new String[]{"properties"};
        }

        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return new PropertiesConfigSource(url, ordinal);
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            return this.loadConfigSources(OpenTelemetryDevServicesConfigBuilder.OPENTELEMETRY_DEVSERVICES_CONFIG, -2147483148);
        }
    }
}

