/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.cdi;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.annotations.SpanAttribute;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.util.SpanNames;
import io.quarkus.opentelemetry.runtime.tracing.cdi.MethodRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Priority(value=0)
public class WithSpanInterceptor {
    private final Instrumenter<MethodRequest, Void> instrumenter;

    public WithSpanInterceptor(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new MethodRequestSpanNameExtractor());
        MethodSpanAttributesExtractor attributesExtractor = MethodSpanAttributesExtractor.newInstance(MethodRequest::getMethod, (ParameterAttributeNamesExtractor)new WithSpanParameterAttributeNamesExtractor(), MethodRequest::getArgs);
        this.instrumenter = builder.addAttributesExtractor((AttributesExtractor)attributesExtractor).newInstrumenter(methodRequest -> WithSpanInterceptor.spanKindFromMethod(methodRequest.getMethod()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object span(InvocationContext invocationContext) throws Exception {
        MethodRequest methodRequest = new MethodRequest(invocationContext.getMethod(), invocationContext.getParameters());
        Context parentContext = Context.current();
        Context spanContext = null;
        Scope scope = null;
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)methodRequest);
        if (shouldStart) {
            spanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
            scope = spanContext.makeCurrent();
        }
        try {
            Object result = invocationContext.proceed();
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)methodRequest, null, null);
            }
            Object object = result;
            return object;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    private static SpanKind spanKindFromMethod(Method method) {
        WithSpan annotation = method.getDeclaredAnnotation(WithSpan.class);
        if (annotation == null) {
            return SpanKind.INTERNAL;
        }
        return annotation.kind();
    }

    private static final class WithSpanParameterAttributeNamesExtractor
    implements ParameterAttributeNamesExtractor {
        private WithSpanParameterAttributeNamesExtractor() {
        }

        public String[] extract(Method method, Parameter[] parameters) {
            String[] attributeNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                attributeNames[i] = WithSpanParameterAttributeNamesExtractor.attributeName(parameters[i]);
            }
            return attributeNames;
        }

        private static String attributeName(Parameter parameter) {
            SpanAttribute spanAttribute = parameter.getDeclaredAnnotation(SpanAttribute.class);
            if (spanAttribute == null) {
                return null;
            }
            String value = spanAttribute.value();
            if (!value.isEmpty()) {
                return value;
            }
            if (parameter.isNamePresent()) {
                return parameter.getName();
            }
            return null;
        }
    }

    private static final class MethodRequestSpanNameExtractor
    implements SpanNameExtractor<MethodRequest> {
        private MethodRequestSpanNameExtractor() {
        }

        public String extract(MethodRequest methodRequest) {
            WithSpan annotation = methodRequest.getMethod().getDeclaredAnnotation(WithSpan.class);
            String spanName = annotation.value();
            if (spanName.isEmpty()) {
                spanName = SpanNames.fromMethod((Method)methodRequest.getMethod());
            }
            return spanName;
        }
    }
}

