/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.vertx;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteBiGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteSource;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.tracing.vertx.InstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.vertx.VertxUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.TagExtractor;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

class HttpInstrumenterVertxTracer
implements InstrumenterVertxTracer<HttpRequest, HttpResponse> {
    private final Instrumenter<HttpRequest, HttpResponse> serverInstrumenter;
    private final Instrumenter<HttpRequest, HttpResponse> clientInstrumenter;

    public HttpInstrumenterVertxTracer(OpenTelemetry openTelemetry) {
        this.serverInstrumenter = HttpInstrumenterVertxTracer.getServerInstrumenter(openTelemetry);
        this.clientInstrumenter = HttpInstrumenterVertxTracer.getClientInstrumenter(openTelemetry);
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        return request instanceof HttpRequest;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getReceiveRequestInstrumenter() {
        return this.serverInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getSendResponseInstrumenter() {
        return this.serverInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getSendRequestInstrumenter() {
        return this.clientInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getReceiveResponseInstrumenter() {
        return this.clientInstrumenter;
    }

    @Override
    public OpenTelemetryVertxTracer.SpanOperation spanOperation(io.vertx.core.Context context, HttpRequest request, MultiMap headers, Context spanContext, Scope scope) {
        HttpRequestSpan requestSpan = HttpRequestSpan.request(request, headers, context, spanContext);
        return OpenTelemetryVertxTracer.SpanOperation.span(context, requestSpan, headers, spanContext, scope);
    }

    @Override
    public <R> void sendResponse(io.vertx.core.Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        HttpRouteHolder.updateHttpRoute((Context)spanOperation.getSpanContext(), (HttpRouteSource)HttpRouteSource.FILTER, (HttpRouteBiGetter)RouteGetter.ROUTE_GETTER, (Object)((HttpRequestSpan)spanOperation.getRequest()), (Object)((HttpResponse)response));
        InstrumenterVertxTracer.super.sendResponse(context, response, spanOperation, failure, tagExtractor);
    }

    @Override
    public HttpRequest writableHeaders(HttpRequest request, BiConsumer<String, String> headers) {
        return WriteHeadersHttpRequest.request(request, headers);
    }

    private static Instrumenter<HttpRequest, HttpResponse> getServerInstrumenter(OpenTelemetry openTelemetry) {
        ServerAttributesExtractor serverAttributesExtractor = new ServerAttributesExtractor();
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)serverAttributesExtractor));
        return serverBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)new AdditionalServerAttributesExtractor()).addContextCustomizer(HttpRouteHolder.get()).newServerInstrumenter((TextMapGetter)new HttpRequestTextMapGetter());
    }

    private static Instrumenter<HttpRequest, HttpResponse> getClientInstrumenter(OpenTelemetry openTelemetry) {
        ServerAttributesExtractor serverAttributesExtractor = new ServerAttributesExtractor();
        ClientAttributesExtractor clientAttributesExtractor = new ClientAttributesExtractor();
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)clientAttributesExtractor));
        return clientBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor)).newClientInstrumenter((TextMapSetter)new HttpRequestTextMapSetter());
    }

    private static class WriteHeadersHttpRequest
    implements HttpRequest {
        private final HttpRequest httpRequest;
        private final BiConsumer<String, String> headers;

        WriteHeadersHttpRequest(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            this.httpRequest = httpRequest;
            this.headers = headers;
        }

        public int id() {
            return this.httpRequest.id();
        }

        public String uri() {
            return this.httpRequest.uri();
        }

        public String absoluteURI() {
            return this.httpRequest.absoluteURI();
        }

        public HttpMethod method() {
            return this.httpRequest.method();
        }

        public MultiMap headers() {
            HeadersAdaptor headers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new HeadersMultiMap()){

                public MultiMap set(String name, String value) {
                    MultiMap result = super.set(name, value);
                    headers.accept(name, value);
                    return result;
                }
            };
            return headers.addAll(this.httpRequest.headers());
        }

        public SocketAddress remoteAddress() {
            return this.httpRequest.remoteAddress();
        }

        static WriteHeadersHttpRequest request(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            return new WriteHeadersHttpRequest(httpRequest, headers);
        }
    }

    static class HttpRequestSpan
    implements HttpRequest {
        private final HttpRequest httpRequest;
        private final MultiMap headers;
        private final io.vertx.core.Context context;
        private final Context spanContext;

        HttpRequestSpan(HttpRequest httpRequest, MultiMap headers, io.vertx.core.Context context, Context spanContext) {
            this.httpRequest = httpRequest;
            this.headers = headers;
            this.context = context;
            this.spanContext = spanContext;
        }

        public int id() {
            return this.httpRequest.id();
        }

        public String uri() {
            return this.httpRequest.uri();
        }

        public String absoluteURI() {
            return this.httpRequest.absoluteURI();
        }

        public HttpMethod method() {
            return this.httpRequest.method();
        }

        public MultiMap headers() {
            return this.headers;
        }

        public SocketAddress remoteAddress() {
            return this.httpRequest.remoteAddress();
        }

        public io.vertx.core.Context getContext() {
            if (this.context == null) {
                throw new IllegalStateException("The Vert.x Context is not set");
            }
            return this.context;
        }

        public Context getSpanContext() {
            if (this.spanContext == null) {
                throw new IllegalStateException("The OpenTelemetry Context is not set");
            }
            return this.spanContext;
        }

        static HttpRequestSpan request(HttpRequest httpRequest, MultiMap headers, io.vertx.core.Context context, Context spanContext) {
            return new HttpRequestSpan(httpRequest, headers, context, spanContext);
        }
    }

    private static class HttpRequestTextMapSetter
    implements TextMapSetter<HttpRequest> {
        private HttpRequestTextMapSetter() {
        }

        public void set(HttpRequest carrier, String key, String value) {
            if (carrier != null) {
                carrier.headers().set(key, value);
            }
        }
    }

    private static class ClientAttributesExtractor
    implements HttpClientAttributesGetter<HttpRequest, HttpResponse> {
        private ClientAttributesExtractor() {
        }

        public String url(HttpRequest request) {
            return request.absoluteURI();
        }

        public String flavor(HttpRequest request, HttpResponse response) {
            return null;
        }

        public String method(HttpRequest request) {
            return request.method().name();
        }

        public List<String> requestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        public Long requestContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        public Long requestContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        public Integer statusCode(HttpRequest request, HttpResponse response) {
            return response.statusCode();
        }

        public Long responseContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        public Long responseContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        public List<String> responseHeader(HttpRequest request, HttpResponse response, String name) {
            return response.headers().getAll(name);
        }
    }

    private static class HttpRequestTextMapGetter
    implements TextMapGetter<HttpRequest> {
        private HttpRequestTextMapGetter() {
        }

        public Iterable<String> keys(HttpRequest carrier) {
            return carrier.headers().names();
        }

        public String get(HttpRequest carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.headers().get(key);
        }
    }

    private static class AdditionalServerAttributesExtractor
    implements AttributesExtractor<HttpRequest, HttpResponse> {
        private AdditionalServerAttributesExtractor() {
        }

        public void onStart(AttributesBuilder attributes, Context parentContext, HttpRequest httpRequest) {
            String clientIp;
            if (httpRequest instanceof HttpServerRequest && (clientIp = VertxUtil.extractClientIP((HttpServerRequest)httpRequest)) != null) {
                attributes.put(SemanticAttributes.HTTP_CLIENT_IP, (Object)clientIp);
            }
        }

        public void onEnd(AttributesBuilder attributes, Context context, HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
        }
    }

    private static class ServerAttributesExtractor
    implements HttpServerAttributesGetter<HttpRequest, HttpResponse> {
        private ServerAttributesExtractor() {
        }

        public String flavor(HttpRequest request) {
            HttpVersion version;
            if (request instanceof HttpServerRequest && (version = ((HttpServerRequest)request).version()) != null) {
                switch (version) {
                    case HTTP_1_0: {
                        return "1.0";
                    }
                    case HTTP_1_1: {
                        return "1.1";
                    }
                    case HTTP_2: {
                        return "2.0";
                    }
                }
                return version.alpnName();
            }
            return null;
        }

        public String target(HttpRequest request) {
            return request.uri();
        }

        public String route(HttpRequest request) {
            return request.uri().length() > 1 ? request.uri() : null;
        }

        public String scheme(HttpRequest request) {
            if (request instanceof HttpServerRequest) {
                return ((HttpServerRequest)request).scheme();
            }
            return null;
        }

        public String serverName(HttpRequest request) {
            SocketAddress remoteAddress = request.remoteAddress();
            if (remoteAddress != null) {
                return remoteAddress.hostName();
            }
            return null;
        }

        public String method(HttpRequest request) {
            return request.method().name();
        }

        public List<String> requestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        public Long requestContentLength(HttpRequest request, HttpResponse response) {
            return ServerAttributesExtractor.getContentLength(request.headers());
        }

        public Long requestContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        public Integer statusCode(HttpRequest request, HttpResponse response) {
            return response != null ? Integer.valueOf(response.statusCode()) : null;
        }

        public Long responseContentLength(HttpRequest request, HttpResponse response) {
            return response != null ? ServerAttributesExtractor.getContentLength(response.headers()) : null;
        }

        public Long responseContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        public List<String> responseHeader(HttpRequest request, HttpResponse response, String name) {
            return response != null ? response.headers().getAll(name) : Collections.emptyList();
        }

        private static Long getContentLength(MultiMap headers) {
            String contentLength = headers.get(HttpHeaders.CONTENT_LENGTH);
            if (contentLength != null && contentLength.length() > 0) {
                try {
                    return Long.valueOf(contentLength);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private static class RouteGetter
    implements HttpRouteBiGetter<HttpRequestSpan, HttpResponse> {
        static final RouteGetter ROUTE_GETTER = new RouteGetter();

        private RouteGetter() {
        }

        public String get(Context context, HttpRequestSpan requestSpan, HttpResponse response) {
            String route = (String)requestSpan.getContext().getLocal((Object)"UrlPathTemplate");
            if (route == null) {
                route = (String)requestSpan.getContext().getLocal((Object)"VertxRoute");
            }
            if (route != null && route.length() > 1) {
                return route;
            }
            if (response != null && HttpResponseStatus.NOT_FOUND.code() == response.statusCode()) {
                return "/*";
            }
            return null;
        }
    }
}

