/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.quarkus.opentelemetry.runtime.MDCEnabledContextStorage;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Vertx;
import org.jboss.logging.Logger;

public enum QuarkusContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger log;
    private static final String OTEL_CONTEXT;
    private static final ContextStorage FALLBACK_CONTEXT_STORAGE;
    static Vertx vertx;

    public Scope attach(Context toAttach) {
        io.vertx.core.Context vertxContext = QuarkusContextStorage.getVertxContext();
        return vertxContext != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext) ? this.attach(vertxContext, toAttach) : FALLBACK_CONTEXT_STORAGE.attach(toAttach);
    }

    public Scope attach(io.vertx.core.Context vertxContext, Context toAttach) {
        if (vertxContext == null || toAttach == null) {
            return Scope.noop();
        }
        if (!VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext)) {
            throw new IllegalArgumentException("The Vert.x Context to attach the OpenTelemetry Context must be a duplicated Context");
        }
        Context beforeAttach = QuarkusContextStorage.getContext(vertxContext);
        if (toAttach == beforeAttach) {
            return Scope.noop();
        }
        vertxContext.putLocal((Object)OTEL_CONTEXT, (Object)toAttach);
        OpenTelemetryUtil.setMDCData(toAttach, vertxContext);
        return () -> {
            if (QuarkusContextStorage.getContext(vertxContext) != toAttach) {
                log.warn((Object)"Context in storage not the expected context, Scope.close was not called correctly");
            }
            if (beforeAttach == null) {
                vertxContext.removeLocal((Object)OTEL_CONTEXT);
                OpenTelemetryUtil.clearMDCData(vertxContext);
            } else {
                vertxContext.putLocal((Object)OTEL_CONTEXT, (Object)beforeAttach);
                OpenTelemetryUtil.setMDCData(beforeAttach, vertxContext);
            }
        };
    }

    public Context current() {
        io.vertx.core.Context current = QuarkusContextStorage.getVertxContext();
        if (current != null) {
            return (Context)current.getLocal((Object)OTEL_CONTEXT);
        }
        return FALLBACK_CONTEXT_STORAGE.current();
    }

    public static Context getContext(io.vertx.core.Context vertxContext) {
        return vertxContext != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext) ? (Context)vertxContext.getLocal((Object)OTEL_CONTEXT) : null;
    }

    public static io.vertx.core.Context getVertxContext() {
        io.vertx.core.Context context = Vertx.currentContext();
        if (context != null) {
            io.vertx.core.Context dc = VertxContext.getOrCreateDuplicatedContext((io.vertx.core.Context)context);
            VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)dc, (boolean)true);
            return dc;
        }
        return null;
    }

    static {
        log = Logger.getLogger(QuarkusContextStorage.class);
        OTEL_CONTEXT = QuarkusContextStorage.class.getName() + ".otelContext";
        FALLBACK_CONTEXT_STORAGE = MDCEnabledContextStorage.INSTANCE;
    }
}

