/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.quarkus.opentelemetry.runtime.OpenTelemetryConfig;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import java.util.function.Supplier;

@Recorder
public class OpenTelemetryRecorder {
    public void resetGlobalOpenTelemetryForDevMode() {
        GlobalOpenTelemetry.resetForTest();
    }

    public RuntimeValue<OpenTelemetry> createOpenTelemetry(RuntimeValue<SdkTracerProvider> tracerProvider, OpenTelemetryConfig openTelemetryConfig) {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        if (tracerProvider != null) {
            builder.setTracerProvider((SdkTracerProvider)tracerProvider.getValue());
        }
        builder.setPropagators(OpenTelemetryUtil.mapPropagators(openTelemetryConfig.propagators));
        OpenTelemetrySdk openTelemetry = builder.buildAndRegisterGlobal();
        return new RuntimeValue((Object)openTelemetry);
    }

    public void eagerlyCreateContextStorage() {
        ContextStorage.get();
    }

    public void storeVertxOnContextStorage(Supplier<Vertx> vertx) {
        QuarkusContextStorage.vertx = vertx.get();
    }
}

