/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.InetSocketAddressNetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcServerAttributesExtractor;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcAttributesGetter;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcRequest;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcSpanNameExtractor;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcSpanStatusExtractor;
import io.quarkus.opentelemetry.runtime.tracing.grpc.GrpcStatusCodeExtractor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import javax.inject.Singleton;

@Singleton
@GlobalInterceptor
public class GrpcTracingServerInterceptor
implements ServerInterceptor {
    private final Instrumenter<GrpcRequest, Status> instrumenter;

    public GrpcTracingServerInterceptor(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new GrpcSpanNameExtractor());
        builder.addAttributesExtractor((AttributesExtractor)RpcServerAttributesExtractor.create((RpcAttributesGetter)GrpcAttributesGetter.INSTANCE)).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)new GrpcServerNetServerAttributesGetter())).addAttributesExtractor((AttributesExtractor)new GrpcStatusCodeExtractor()).setSpanStatusExtractor((SpanStatusExtractor)new GrpcSpanStatusExtractor());
        this.instrumenter = builder.newServerInstrumenter((TextMapGetter)new GrpcTextMapGetter());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        GrpcRequest grpcRequest = GrpcRequest.server(call.getMethodDescriptor(), headers, call.getAttributes());
        Context parentContext = Context.current();
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)grpcRequest);
        if (shouldStart) {
            Context spanContext = this.instrumenter.start(parentContext, (Object)grpcRequest);
            Scope scope = spanContext.makeCurrent();
            TracingServerCall<ReqT, RespT> tracingServerCall = new TracingServerCall<ReqT, RespT>(call, spanContext, scope, grpcRequest);
            return new TracingServerCallListener(next.startCall(tracingServerCall, headers), spanContext, scope, grpcRequest);
        }
        return next.startCall(call, headers);
    }

    private class TracingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private final Context spanContext;
        private final Scope scope;
        private final GrpcRequest grpcRequest;

        public TracingServerCall(ServerCall<ReqT, RespT> delegate, Context spanContext, Scope scope, GrpcRequest grpcRequest) {
            super(delegate);
            this.spanContext = spanContext;
            this.scope = scope;
            this.grpcRequest = grpcRequest;
        }

        public void close(Status status, Metadata trailers) {
            try {
                super.close(status, trailers);
            }
            catch (Exception e) {
                try (Scope scope = this.scope;){
                    GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, null, (Throwable)e);
                }
                throw e;
            }
            try (Scope scope = this.scope;){
                GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, (Object)status, status.getCause());
            }
        }
    }

    private class TracingServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final Context spanContext;
        private final Scope scope;
        private final GrpcRequest grpcRequest;

        protected TracingServerCallListener(ServerCall.Listener<ReqT> delegate, Context spanContext, Scope scope, GrpcRequest grpcRequest) {
            super(delegate);
            this.scope = scope;
            this.spanContext = spanContext;
            this.grpcRequest = grpcRequest;
        }

        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (Exception e) {
                try (Scope scope = this.scope;){
                    GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, null, (Throwable)e);
                }
                throw e;
            }
        }

        public void onCancel() {
            try {
                super.onCancel();
            }
            catch (Exception e) {
                try (Scope scope = this.scope;){
                    GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, null, (Throwable)e);
                }
                throw e;
            }
            try (Scope scope = this.scope;){
                GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, (Object)Status.CANCELLED, null);
            }
        }

        public void onComplete() {
            try {
                super.onComplete();
            }
            catch (Exception e) {
                try (Scope scope = this.scope;){
                    GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, null, (Throwable)e);
                }
                throw e;
            }
        }

        public void onReady() {
            try {
                super.onReady();
            }
            catch (Exception e) {
                try (Scope scope = this.scope;){
                    GrpcTracingServerInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, null, (Throwable)e);
                }
                throw e;
            }
        }
    }

    private static class GrpcTextMapGetter
    implements TextMapGetter<GrpcRequest> {
        private GrpcTextMapGetter() {
        }

        public Iterable<String> keys(GrpcRequest carrier) {
            return carrier.getMetadata() != null ? carrier.getMetadata().keys() : Collections.emptySet();
        }

        public String get(GrpcRequest carrier, String key) {
            if (carrier != null && carrier.getMetadata() != null) {
                return (String)carrier.getMetadata().get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            }
            return null;
        }
    }

    private static class GrpcServerNetServerAttributesGetter
    extends InetSocketAddressNetServerAttributesGetter<GrpcRequest> {
        private GrpcServerNetServerAttributesGetter() {
        }

        public InetSocketAddress getAddress(GrpcRequest grpcRequest) {
            SocketAddress socketAddress = (SocketAddress)grpcRequest.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            if (socketAddress instanceof InetSocketAddress) {
                return (InetSocketAddress)socketAddress;
            }
            return null;
        }

        public String transport(GrpcRequest grpcRequest) {
            return "ip_tcp";
        }
    }
}

