/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.opentelemetry.runtime.tracing.DropTargetsSampler;
import io.quarkus.opentelemetry.runtime.tracing.LateBoundSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.CDI;

public class TracerUtil {
    private TracerUtil() {
    }

    public static Resource mapResourceAttributes(List<String> resourceAttributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryUtil.convertKeyValueListToMap(resourceAttributes).forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return Resource.create((Attributes)attributesBuilder.build());
    }

    private static Sampler getBaseSampler(String samplerName, Optional<Double> ratio) {
        switch (samplerName) {
            case "on": {
                return Sampler.alwaysOn();
            }
            case "off": {
                return Sampler.alwaysOff();
            }
            case "ratio": {
                return Sampler.traceIdRatioBased((double)ratio.orElse(1.0));
            }
        }
        throw new IllegalArgumentException("Unrecognized value for sampler: " + samplerName);
    }

    public static Sampler mapSampler(TracerRuntimeConfig.SamplerConfig samplerConfig, List<String> dropTargets) {
        Sampler sampler = CDI.current().select(Sampler.class, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(o -> !(o instanceof LateBoundSampler)).findFirst().orElseGet(() -> TracerUtil.getBaseSampler(samplerConfig.samplerName, samplerConfig.ratio));
        if (!dropTargets.isEmpty()) {
            sampler = new DropTargetsSampler(sampler, dropTargets);
        }
        if (samplerConfig.parentBased.booleanValue()) {
            return Sampler.parentBased((Sampler)sampler);
        }
        return sampler;
    }
}

