/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import org.jboss.logging.Logger;

public class LateBoundBatchSpanProcessor
implements SpanProcessor {
    private static final Logger log = Logger.getLogger(LateBoundBatchSpanProcessor.class);
    private boolean warningLogged = false;
    private BatchSpanProcessor delegate;

    public void setBatchSpanProcessorDelegate(BatchSpanProcessor delegate) {
        this.delegate = delegate;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return;
        }
        this.delegate.onStart(parentContext, span);
    }

    public boolean isStartRequired() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return false;
        }
        return this.delegate.isStartRequired();
    }

    public void onEnd(ReadableSpan span) {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return;
        }
        this.delegate.onEnd(span);
    }

    public boolean isEndRequired() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return true;
        }
        return this.delegate.isEndRequired();
    }

    public CompletableResultCode shutdown() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return CompletableResultCode.ofSuccess();
        }
        return this.delegate.shutdown();
    }

    public CompletableResultCode forceFlush() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return CompletableResultCode.ofSuccess();
        }
        return this.delegate.forceFlush();
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.resetDelegate();
    }

    private void resetDelegate() {
        this.delegate = null;
        this.warningLogged = false;
    }

    private void logDelegateNotFound() {
        if (!this.warningLogged) {
            log.warn((Object)"No BatchSpanProcessor delegate specified, no action taken.");
            this.warningLogged = true;
        }
    }
}

