/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.EventBusInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.HttpInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxMetricsFactory;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracingDevModeFactory;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracingFactory;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.SqlClientInstrumenterVertxTracer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import java.util.ArrayList;
import java.util.function.Consumer;

@Recorder
public class InstrumentationRecorder {
    public static final OpenTelemetryVertxTracingDevModeFactory FACTORY = new OpenTelemetryVertxTracingDevModeFactory();

    public RuntimeValue<OpenTelemetryVertxTracer> createTracers() {
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        ArrayList instrumenterVertxTracers = new ArrayList();
        instrumenterVertxTracers.add(new HttpInstrumenterVertxTracer(openTelemetry));
        instrumenterVertxTracers.add(new EventBusInstrumenterVertxTracer(openTelemetry));
        instrumenterVertxTracers.add(new SqlClientInstrumenterVertxTracer(openTelemetry));
        return new RuntimeValue((Object)new OpenTelemetryVertxTracer(instrumenterVertxTracers));
    }

    public Consumer<VertxOptions> getVertxTracingOptionsProd(RuntimeValue<OpenTelemetryVertxTracer> tracer) {
        TracingOptions tracingOptions = new TracingOptions().setFactory((VertxTracerFactory)new OpenTelemetryVertxTracingFactory((OpenTelemetryVertxTracer)tracer.getValue()));
        return vertxOptions -> vertxOptions.setTracingOptions(tracingOptions);
    }

    public Consumer<VertxOptions> getVertxTracingOptionsDevMode() {
        TracingOptions tracingOptions = new TracingOptions().setFactory((VertxTracerFactory)FACTORY);
        return vertxOptions -> vertxOptions.setTracingOptions(tracingOptions);
    }

    public void setTracerDevMode(RuntimeValue<OpenTelemetryVertxTracer> tracer) {
        FACTORY.getVertxTracerDelegator().setDelegate((VertxTracer)tracer.getValue());
    }

    public Consumer<VertxOptions> getVertxTracingMetricsOptions() {
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new OpenTelemetryVertxMetricsFactory());
        return vertxOptions -> vertxOptions.setMetricsOptions(metricsOptions);
    }
}

