/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.quarkus.runtime.configuration.NormalizeRootHttpPathConverter;
import io.smallrye.config.SmallRyeConfig;
import java.util.List;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class NonApplicationEndpointSampler
implements Sampler {
    private static final SamplingResult NEGATIVE_SAMPLING_RESULT = SamplingResult.create((SamplingDecision)SamplingDecision.DROP);
    private final Sampler sampler;
    private final String namePattern;

    public NonApplicationEndpointSampler(Sampler sampler) {
        this.sampler = sampler;
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        if (config.isPropertyPresent("quarkus.http.root-path")) {
            String rootPath = (String)config.getValue("quarkus.http.root-path", (Converter)new NormalizeRootHttpPathConverter());
            String nonApplicationRootPath = config.getRawValue("quarkus.http.non-application-root-path");
            this.namePattern = rootPath.substring(1) + nonApplicationRootPath;
        } else {
            this.namePattern = null;
        }
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (this.namePattern != null && name.startsWith(this.namePattern) && spanKind == SpanKind.SERVER) {
            return NEGATIVE_SAMPLING_RESULT;
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return "NonApplicationEndpointBased{/q}";
    }
}

