/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.restclient;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.quarkus.arc.Unremovable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Unremovable
@Provider
public class OpenTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT = "otel.span.client.context";
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT = "otel.span.client.parentContext";
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE = "otel.span.client.scope";
    private Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;

    public OpenTelemetryClientFilter() {
        this(GlobalOpenTelemetry.get());
    }

    @Inject
    public OpenTelemetryClientFilter(OpenTelemetry openTelemetry) {
        ClientAttributesExtractor clientAttributesExtractor = new ClientAttributesExtractor();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new ClientSpanNameExtractor());
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesExtractor)clientAttributesExtractor)).addAttributesExtractor((AttributesExtractor)clientAttributesExtractor).newClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
    }

    public void filter(ClientRequestContext request) {
        Context parentContext = Context.current();
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT, (Object)spanContext);
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT, (Object)parentContext);
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE, (Object)scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext request, ClientResponseContext response) {
        Scope scope = (Scope)request.getProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE);
        if (scope == null) {
            return;
        }
        Context spanContext = (Context)request.getProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT);
        try {
            this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
        }
        finally {
            scope.close();
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT);
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT);
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE);
        }
    }

    private static class ClientAttributesExtractor
    extends HttpClientAttributesExtractor<ClientRequestContext, ClientResponseContext> {
        private ClientAttributesExtractor() {
        }

        protected String url(ClientRequestContext request) {
            URI uri = request.getUri();
            if (uri.getUserInfo() != null) {
                return UriBuilder.fromUri((URI)uri).userInfo(null).build(new Object[0]).toString();
            }
            return uri.toString();
        }

        protected String flavor(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        protected String method(ClientRequestContext request) {
            return request.getMethod();
        }

        protected List<String> requestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        protected Long requestContentLength(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        protected Long requestContentLengthUncompressed(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        protected Integer statusCode(ClientRequestContext request, ClientResponseContext response) {
            return response.getStatus();
        }

        protected Long responseContentLength(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        protected Long responseContentLengthUncompressed(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        protected List<String> responseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }
    }

    private static class ClientSpanNameExtractor
    implements SpanNameExtractor<ClientRequestContext> {
        private ClientSpanNameExtractor() {
        }

        public String extract(ClientRequestContext request) {
            String pathTemplate = (String)request.getProperty("UrlPathTemplate");
            if (pathTemplate != null && pathTemplate.length() > 1) {
                return pathTemplate.substring(1);
            }
            String uriPath = request.getUri().getPath();
            if (uriPath.length() > 1) {
                return uriPath.substring(1);
            }
            return "HTTP " + request.getMethod();
        }
    }

    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }
    }
}

