/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.vertx;

import io.vertx.core.http.HttpServerRequest;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class VertxUtil {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    private static final String FORWARDED = "Forwarded";
    private static final String COMMA_SPLITTER = ",";
    private static final int SPLIT_LIMIT = -1;

    private VertxUtil() {
    }

    private static Optional<String> getForwardedHeaderValue(HttpServerRequest httpServerRequest) {
        return Optional.ofNullable(httpServerRequest.getHeader(FORWARDED)).map(FORWARDED_FOR_PATTERN::matcher).filter(Matcher::find).map(matcher -> matcher.group(1).trim());
    }

    private static Optional<String> getXForwardedHeaderValue(HttpServerRequest httpServerRequest) {
        return Optional.ofNullable(httpServerRequest.getHeader(X_FORWARDED_FOR)).flatMap(o -> Stream.of(o.split(COMMA_SPLITTER, -1)).findFirst());
    }

    public static String extractClientIP(HttpServerRequest httpServerRequest) {
        return VertxUtil.getForwardedHeaderValue(httpServerRequest).orElseGet(() -> VertxUtil.getXForwardedHeaderValue(httpServerRequest).orElseGet(() -> httpServerRequest.remoteAddress() != null ? httpServerRequest.remoteAddress().host() : null));
    }
}

