/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.vertx;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.quarkus.opentelemetry.runtime.tracing.vertx.InstrumenterVertxTracer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.spi.tracing.TagExtractor;

public class EventBusInstrumenterVertxTracer
implements InstrumenterVertxTracer<Message, Message> {
    private final Instrumenter<Message, Message> consumerInstrumenter;
    private final Instrumenter<Message, Message> producerInstrumenter;

    public EventBusInstrumenterVertxTracer(OpenTelemetry openTelemetry) {
        this.consumerInstrumenter = EventBusInstrumenterVertxTracer.getConsumerInstrumenter(openTelemetry);
        this.producerInstrumenter = EventBusInstrumenterVertxTracer.getProducerInstrumenter(openTelemetry);
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        return request instanceof Message;
    }

    @Override
    public Instrumenter<Message, Message> getReceiveRequestInstrumenter() {
        return this.consumerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getSendResponseInstrumenter() {
        return this.consumerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getSendRequestInstrumenter() {
        return this.producerInstrumenter;
    }

    @Override
    public Instrumenter<Message, Message> getReceiveResponseInstrumenter() {
        return this.producerInstrumenter;
    }

    private static Instrumenter<Message, Message> getConsumerInstrumenter(OpenTelemetry openTelemetry) {
        EventBusAttributesExtractor eventBusAttributesExtractor = new EventBusAttributesExtractor(MessageOperation.RECEIVE);
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesExtractor)eventBusAttributesExtractor));
        return serverBuilder.addAttributesExtractor((AttributesExtractor)eventBusAttributesExtractor).newConsumerInstrumenter((TextMapGetter)new TextMapGetter<Message>(){

            public Iterable<String> keys(Message message) {
                return message.headers().names();
            }

            public String get(Message message, String key) {
                if (message == null) {
                    return null;
                }
                return message.headers().get(key);
            }
        });
    }

    private static Instrumenter<Message, Message> getProducerInstrumenter(OpenTelemetry openTelemetry) {
        EventBusAttributesExtractor eventBusAttributesExtractor = new EventBusAttributesExtractor(MessageOperation.SEND);
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesExtractor)eventBusAttributesExtractor));
        return serverBuilder.addAttributesExtractor((AttributesExtractor)eventBusAttributesExtractor).newProducerInstrumenter((message, key, value) -> {
            if (message != null) {
                message.headers().set(key, value);
            }
        });
    }

    private static class EventBusAttributesExtractor
    extends MessagingAttributesExtractor<Message, Message> {
        private final MessageOperation operation;

        public EventBusAttributesExtractor(MessageOperation operation) {
            this.operation = operation;
        }

        public MessageOperation operation() {
            return this.operation;
        }

        protected String system(Message message) {
            return "vert.x";
        }

        protected String destinationKind(Message message) {
            return message.isSend() ? "queue" : "topic";
        }

        protected String destination(Message message) {
            return message.address();
        }

        protected boolean temporaryDestination(Message message) {
            return false;
        }

        protected String protocol(Message message) {
            return null;
        }

        protected String protocolVersion(Message message) {
            return "4.0";
        }

        protected String url(Message message) {
            return null;
        }

        protected String conversationId(Message message) {
            return message.replyAddress();
        }

        protected Long messagePayloadSize(Message message) {
            return null;
        }

        protected Long messagePayloadCompressedSize(Message message) {
            return null;
        }

        protected String messageId(Message message, Message message2) {
            return null;
        }
    }
}

