/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.DefaultBean;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.opentelemetry.runtime.config.OtelConfigRelocateConfigSourceInterceptor;
import io.quarkus.opentelemetry.runtime.config.build.LegacySamplerNameConverter;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.tracing.DropTargetsSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerUtil;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class OpenTelemetryProducer {
    private static final String QUARKUS_OTEL_PREFIX_PROP = "quarkus.otel.";
    private static final String QUARKUS_OTEL_LEGACY_PREFIX_PROP = "quarkus.opentelemetry.";
    private static final String QUARKUS_OTEL_TRACES_SAMPLER_PROP_NAME = "quarkus.otel.traces.sampler";
    private static final String QUARKUS_ENV_PREFIX = "quarkus.";
    @Inject
    private Instance<IdGenerator> idGenerator;
    @Inject
    @Any
    private Instance<Resource> resources;
    @Inject
    @Any
    private Instance<DelayedAttributes> delayedAttributes;
    @Inject
    @Any
    private Instance<Sampler> sampler;
    @Inject
    @Any
    private Instance<SpanProcessor> spanProcessors;
    @Inject
    @ConfigProperty(name="quarkus.otel.traces.enabled")
    Optional<Boolean> tracesEnabled;
    @Inject
    @ConfigProperty(name="quarkus.otel.sdk.disabled")
    boolean sdkDisabled;
    @Inject
    @ConfigProperty(name="quarkus.otel.resource.attributes")
    Optional<List<String>> resourceAttributes;
    @Inject
    @ConfigProperty(name="quarkus.otel.traces.suppress-non-application-uris")
    boolean suppressNonApplicationUris;
    @Inject
    @ConfigProperty(name="quarkus.otel.traces.include-static-resources")
    boolean includeStaticResources;

    @Produces
    @Singleton
    @DefaultBean
    public OpenTelemetry getOpenTelemetry() {
        Map<String, String> oTelConfigs = this.getOtelConfigs();
        if (this.sdkDisabled) {
            return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).registerShutdownHook(false).addPropertiesSupplier(() -> oTelConfigs).build().getOpenTelemetrySdk();
        }
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).registerShutdownHook(false).addPropertiesSupplier(() -> oTelConfigs).setServiceClassLoader(Thread.currentThread().getContextClassLoader()).addResourceCustomizer((BiFunction)new BiFunction<Resource, ConfigProperties, Resource>(){

            @Override
            public Resource apply(Resource existingResource, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.tracesEnabled.orElse(Boolean.TRUE).booleanValue()) {
                    Resource consolidatedResource = existingResource.merge(Resource.create((Attributes)((Attributes)OpenTelemetryProducer.this.delayedAttributes.get())));
                    Resource resource = OpenTelemetryProducer.this.resources.stream().reduce(Resource.empty(), Resource::merge).merge(TracerUtil.mapResourceAttributes(OpenTelemetryProducer.this.resourceAttributes.orElse(Collections.emptyList())));
                    return consolidatedResource.merge(resource);
                }
                return Resource.builder().build();
            }
        }).addSamplerCustomizer((BiFunction)new BiFunction<Sampler, ConfigProperties, Sampler>(){

            @Override
            public Sampler apply(Sampler existingSampler, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.tracesEnabled.orElse(Boolean.TRUE).booleanValue()) {
                    Sampler effectiveSampler = OpenTelemetryProducer.this.sampler.stream().findFirst().map(Sampler.class::cast).orElse(existingSampler);
                    ArrayList<String> dropTargets = new ArrayList<String>();
                    if (OpenTelemetryProducer.this.suppressNonApplicationUris) {
                        dropTargets.addAll(TracerRecorder.dropNonApplicationUriTargets);
                    }
                    if (!OpenTelemetryProducer.this.includeStaticResources) {
                        dropTargets.addAll(TracerRecorder.dropStaticResourceTargets);
                    }
                    if (!dropTargets.isEmpty()) {
                        return new DropTargetsSampler(effectiveSampler, dropTargets);
                    }
                    return effectiveSampler;
                }
                return Sampler.alwaysOff();
            }
        }).addTracerProviderCustomizer((BiFunction)new BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder>(){

            @Override
            public SdkTracerProviderBuilder apply(SdkTracerProviderBuilder builder, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.tracesEnabled.orElse(Boolean.TRUE).booleanValue()) {
                    OpenTelemetryProducer.this.idGenerator.stream().findFirst().ifPresent(arg_0 -> ((SdkTracerProviderBuilder)builder).setIdGenerator(arg_0));
                    OpenTelemetryProducer.this.spanProcessors.stream().forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
                }
                return builder;
            }
        }).build();
        return autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
    }

    private Map<String, String> getOtelConfigs() {
        final HashMap<String, String> oTelConfigs = new HashMap<String, String>();
        Config config = ConfigProvider.getConfig();
        oTelConfigs.put("otel.java.global-autoconfigure.enabled", "true");
        for (final String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith(QUARKUS_OTEL_PREFIX_PROP)) continue;
            config.getOptionalValue(propertyName, String.class).ifPresent(new Consumer<String>(){

                @Override
                public void accept(String value) {
                    if (propertyName.equals(OpenTelemetryProducer.QUARKUS_OTEL_TRACES_SAMPLER_PROP_NAME)) {
                        value = new LegacySamplerNameConverter().convert(value);
                    }
                    oTelConfigs.put(OpenTelemetryProducer.this.transformPropertyName(propertyName), value);
                }
            });
        }
        for (String oldPropertyName : config.getPropertyNames()) {
            String newPropertyName;
            if (!oldPropertyName.startsWith(QUARKUS_OTEL_LEGACY_PREFIX_PROP) || (newPropertyName = OtelConfigRelocateConfigSourceInterceptor.RELOCATIONS.get(oldPropertyName)) == null) continue;
            config.getOptionalValue(oldPropertyName, String.class).ifPresent(new Consumer<String>(){

                @Override
                public void accept(String value) {
                    if (newPropertyName.equals(OpenTelemetryProducer.QUARKUS_OTEL_TRACES_SAMPLER_PROP_NAME)) {
                        value = new LegacySamplerNameConverter().convert(value);
                    }
                    oTelConfigs.put(OpenTelemetryProducer.this.transformPropertyName(newPropertyName), value);
                }
            });
        }
        return oTelConfigs;
    }

    private String transformPropertyName(String propertyName) {
        return OpenTelemetryUtil.subStringAfter(propertyName, QUARKUS_ENV_PREFIX);
    }
}

