/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import jakarta.annotation.Priority;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

@Priority(value=3595)
public class OtelConfigRelocateConfigSourceInterceptor
extends RelocateConfigSourceInterceptor {
    public static final Map<String, String> RELOCATIONS = OtelConfigRelocateConfigSourceInterceptor.relocations();

    public OtelConfigRelocateConfigSourceInterceptor() {
        super(RELOCATIONS);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            String mappedName = RELOCATIONS.get(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        return context.iterateValues();
    }

    private static Map<String, String> relocations() {
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("quarkus.opentelemetry.tracer.exporter.otlp.enabled", "quarkus.otel.exporter.otlp.enabled");
        relocations.put("quarkus.opentelemetry.tracer.exporter.otlp.endpoint", "quarkus.otel.exporter.otlp.traces.legacy-endpoint");
        relocations.put("quarkus.opentelemetry.enabled", "quarkus.otel.enabled");
        relocations.put("quarkus.opentelemetry.tracer.enabled", "quarkus.otel.traces.enabled");
        relocations.put("quarkus.opentelemetry.tracer.sampler", "quarkus.otel.traces.sampler");
        relocations.put("quarkus.opentelemetry.tracer.sampler.ratio", "quarkus.otel.traces.sampler.arg");
        relocations.put("quarkus.opentelemetry.tracer.suppress-non-application-uris", "quarkus.otel.traces.suppress-non-application-uris");
        relocations.put("quarkus.opentelemetry.tracer.include-static-resources", "quarkus.otel.traces.include-static-resources");
        return Collections.unmodifiableMap(relocations);
    }
}

