/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.opentelemetry.runtime.config.runtime.OtelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtelConnectionRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.LateBoundBatchSpanProcessor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;

@Recorder
public class OtlpRecorder {
    static String resolveEndpoint(LaunchMode launchMode, OtlpExporterRuntimeConfig runtimeConfig) {
        String endpoint = runtimeConfig.traces.legacyEndpoint.orElse(runtimeConfig.traces.endpoint.orElse(runtimeConfig.endpoint.orElse("")));
        if (launchMode == LaunchMode.DEVELOPMENT && endpoint.isEmpty()) {
            endpoint = "http://localhost:4317/";
        }
        return endpoint.trim();
    }

    public void installBatchSpanProcessorForOtlp(OtelRuntimeConfig otelRuntimeConfig, OtlpExporterRuntimeConfig exporterRuntimeConfig, LaunchMode launchMode) {
        if (otelRuntimeConfig.sdkDisabled) {
            return;
        }
        String endpoint = OtlpRecorder.resolveEndpoint(launchMode, exporterRuntimeConfig).trim();
        if (endpoint.length() > 0) {
            try {
                SpanExporter spanExporter = CDI.current().select(SpanExporter.class, new Annotation[]{Any.Literal.INSTANCE}).stream().findFirst().orElse(null);
                if (spanExporter == null) {
                    spanExporter = this.createOtlpGrpcSpanExporter(exporterRuntimeConfig, endpoint);
                    LateBoundBatchSpanProcessor delayedProcessor = (LateBoundBatchSpanProcessor)CDI.current().select(LateBoundBatchSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
                    BatchSpanProcessorBuilder processorBuilder = BatchSpanProcessor.builder((SpanExporter)spanExporter);
                    processorBuilder.setScheduleDelay(otelRuntimeConfig.bsp.scheduleDelay);
                    processorBuilder.setMaxQueueSize(otelRuntimeConfig.bsp.maxQueueSize.intValue());
                    processorBuilder.setMaxExportBatchSize(otelRuntimeConfig.bsp.maxExportBatchSize.intValue());
                    processorBuilder.setExporterTimeout(otelRuntimeConfig.bsp.exportTimeout);
                    delayedProcessor.setBatchSpanProcessorDelegate(processorBuilder.build());
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Unable to install OTLP Exporter", iae);
            }
        }
    }

    private OtlpGrpcSpanExporter createOtlpGrpcSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig, String endpoint) {
        final OtlpGrpcSpanExporterBuilder exporterBuilder = OtlpGrpcSpanExporter.builder().setEndpoint(endpoint).setTimeout(exporterRuntimeConfig.traces.timeout);
        exporterRuntimeConfig.traces.headers.forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)exporterBuilder).addHeader(arg_0, arg_1));
        exporterRuntimeConfig.traces.compression.ifPresent(new Consumer<OtelConnectionRuntimeConfig.CompressionType>(){

            @Override
            public void accept(OtelConnectionRuntimeConfig.CompressionType compression) {
                exporterBuilder.setCompression(compression.getValue());
            }
        });
        if (!exporterRuntimeConfig.traces.protocol.orElse("").equals("http/protobuf")) {
            throw new IllegalStateException("Only the GRPC Exporter is currently supported. Please check `otel.exporter.otlp.traces.protocol` property");
        }
        return exporterBuilder.build();
    }
}

