/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;

public class DropTargetsSampler
implements Sampler {
    private final Sampler sampler;
    private final List<String> dropTargets;

    public DropTargetsSampler(Sampler sampler, List<String> dropTargets) {
        this.sampler = sampler;
        this.dropTargets = dropTargets;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        String target;
        if (spanKind.equals((Object)SpanKind.SERVER) && (target = (String)attributes.get(SemanticAttributes.HTTP_TARGET)) != null && this.dropTargets.contains(target)) {
            return SamplingResult.drop();
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

