/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.DefaultBean;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.tracing.DropTargetsSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerUtil;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.microprofile.config.ConfigProvider;

@Singleton
public class OpenTelemetryProducer {
    @Inject
    Instance<IdGenerator> idGenerator;
    @Inject
    @Any
    Instance<Resource> resources;
    @Inject
    @Any
    Instance<DelayedAttributes> delayedAttributes;
    @Inject
    @Any
    Instance<Sampler> sampler;
    @Inject
    @Any
    Instance<SpanProcessor> spanProcessors;
    @Inject
    OTelBuildConfig oTelBuildConfig;
    @Inject
    OTelRuntimeConfig oTelRuntimeConfig;

    @Produces
    @Singleton
    @DefaultBean
    public OpenTelemetry getOpenTelemetry() {
        Map<String, String> oTelConfigs = this.getOtelConfigs();
        if (this.oTelRuntimeConfig.sdkDisabled()) {
            return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).registerShutdownHook(false).addPropertiesSupplier(() -> oTelConfigs).build().getOpenTelemetrySdk();
        }
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).registerShutdownHook(false).addPropertiesSupplier(() -> oTelConfigs).setServiceClassLoader(Thread.currentThread().getContextClassLoader()).addResourceCustomizer((BiFunction)new BiFunction<Resource, ConfigProperties, Resource>(){

            @Override
            public Resource apply(Resource existingResource, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                    Resource consolidatedResource = existingResource.merge(Resource.create((Attributes)((Attributes)OpenTelemetryProducer.this.delayedAttributes.get())));
                    Resource resource = OpenTelemetryProducer.this.resources.stream().reduce(Resource.empty(), Resource::merge).merge(TracerUtil.mapResourceAttributes(OpenTelemetryProducer.this.oTelRuntimeConfig.resourceAttributes().orElse(Collections.emptyList())));
                    return consolidatedResource.merge(resource);
                }
                return Resource.builder().build();
            }
        }).addSamplerCustomizer((BiFunction)new BiFunction<Sampler, ConfigProperties, Sampler>(){

            @Override
            public Sampler apply(Sampler existingSampler, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                    Sampler effectiveSampler = OpenTelemetryProducer.this.sampler.stream().findFirst().map(Sampler.class::cast).orElse(existingSampler);
                    ArrayList<String> dropTargets = new ArrayList<String>();
                    if (OpenTelemetryProducer.this.oTelRuntimeConfig.traces().suppressNonApplicationUris().booleanValue()) {
                        dropTargets.addAll(TracerRecorder.dropNonApplicationUriTargets);
                    }
                    if (!OpenTelemetryProducer.this.oTelRuntimeConfig.traces().includeStaticResources().booleanValue()) {
                        dropTargets.addAll(TracerRecorder.dropStaticResourceTargets);
                    }
                    if (!dropTargets.isEmpty()) {
                        return new DropTargetsSampler(effectiveSampler, dropTargets);
                    }
                    return effectiveSampler;
                }
                return Sampler.alwaysOff();
            }
        }).addTracerProviderCustomizer((BiFunction)new BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder>(){

            @Override
            public SdkTracerProviderBuilder apply(SdkTracerProviderBuilder builder, ConfigProperties configProperties) {
                if (OpenTelemetryProducer.this.oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                    OpenTelemetryProducer.this.idGenerator.stream().findFirst().ifPresent(arg_0 -> ((SdkTracerProviderBuilder)builder).setIdGenerator(arg_0));
                    OpenTelemetryProducer.this.spanProcessors.stream().forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
                }
                return builder;
            }
        }).build();
        return autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
    }

    private Map<String, String> getOtelConfigs() {
        HashMap<String, String> oTelConfigs = new HashMap<String, String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        oTelConfigs.put("otel.java.global-autoconfigure.enabled", "true");
        for (String propertyName : config.getPropertyNames()) {
            ConfigValue configValue;
            if (!propertyName.startsWith("quarkus.otel.") || (configValue = config.getConfigValue(propertyName)).getValue() == null) continue;
            NameIterator name = new NameIterator(propertyName);
            name.next();
            oTelConfigs.put(name.getName().substring(name.getPosition() + 1), configValue.getValue());
        }
        return oTelConfigs;
    }
}

