/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterUtil;
import io.quarkus.vertx.core.runtime.BufferOutputStream;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

final class VertxGrpcExporter
implements SpanExporter {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.trace.v1.TraceService";
    private static final String GRPC_METHOD_NAME = "Export";
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private static final Logger internalLogger = Logger.getLogger(VertxGrpcExporter.class.getName());
    private static final int MAX_ATTEMPTS = 3;
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final CompletableResultCode shutdownResult = new CompletableResultCode();
    private final String type;
    private final ExporterMetrics exporterMetrics;
    private final SocketAddress server;
    private final boolean compressionEnabled;
    private final Map<String, String> headers;
    private final GrpcClient client;

    VertxGrpcExporter(String exporterName, String type, Supplier<MeterProvider> meterProviderSupplier, URI grpcBaseUri, boolean compressionEnabled, Duration timeout, Map<String, String> headersMap, Consumer<HttpClientOptions> clientOptionsCustomizer, Vertx vertx) {
        this.type = type;
        this.exporterMetrics = ExporterMetrics.createGrpcOkHttp((String)exporterName, (String)type, meterProviderSupplier);
        this.server = SocketAddress.inetSocketAddress((int)OTelExporterUtil.getPort(grpcBaseUri), (String)grpcBaseUri.getHost());
        this.compressionEnabled = compressionEnabled;
        this.headers = headersMap;
        HttpClientOptions httpClientOptions = new HttpClientOptions().setHttp2ClearTextUpgrade(false).setReadIdleTimeout((int)timeout.getSeconds()).setTracingPolicy(TracingPolicy.IGNORE);
        clientOptionsCustomizer.accept(httpClientOptions);
        this.client = GrpcClient.client((Vertx)vertx, (HttpClientOptions)httpClientOptions);
    }

    private CompletableResultCode export(TraceRequestMarshaler marshaler, final int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen((long)numItems);
        final CompletableResultCode result = new CompletableResultCode();
        ClientRequestOnSuccessHandler onSuccessHandler = new ClientRequestOnSuccessHandler(this.client, this.server, this.headers, this.compressionEnabled, this.exporterMetrics, marshaler, this.loggedUnimplemented, this.logger, this.type, numItems, result, 1);
        VertxGrpcExporter.initiateSend(this.client, this.server, 3, onSuccessHandler, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                VertxGrpcExporter.this.failOnClientRequest(numItems, throwable, result);
            }
        });
        return result;
    }

    private static void initiateSend(final GrpcClient client, final SocketAddress server, int numberOfAttempts, final Handler<GrpcClientRequest<Buffer, Buffer>> onSuccessHandler, Consumer<Throwable> onFailureCallback) {
        Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<GrpcClientRequest<Buffer, Buffer>>>(){

            @Override
            public CompletionStage<GrpcClientRequest<Buffer, Buffer>> get() {
                return client.request(server).toCompletionStage();
            }
        }).onFailure().retry().withBackOff(Duration.ofMillis(100L)).atMost((long)numberOfAttempts).subscribe().with((Consumer)new Consumer<GrpcClientRequest<Buffer, Buffer>>(){

            @Override
            public void accept(GrpcClientRequest<Buffer, Buffer> request) {
                onSuccessHandler.handle(request);
            }
        }, onFailureCallback);
    }

    private void failOnClientRequest(int numItems, Throwable t, CompletableResultCode result) {
        this.exporterMetrics.addFailed((long)numItems);
        this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Full error message: " + t.getMessage());
        result.fail();
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.export(request, spans.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.FINE, "Calling shutdown() multiple times.");
            return this.shutdownResult;
        }
        this.client.close().onSuccess((Handler)new Handler<Void>(){

            public void handle(Void event) {
                VertxGrpcExporter.this.shutdownResult.succeed();
            }
        }).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                VertxGrpcExporter.this.shutdownResult.fail();
            }
        });
        return this.shutdownResult;
    }

    private static final class ClientRequestOnSuccessHandler
    implements Handler<GrpcClientRequest<Buffer, Buffer>> {
        private final GrpcClient client;
        private final SocketAddress server;
        private final Map<String, String> headers;
        private final boolean compressionEnabled;
        private final ExporterMetrics exporterMetrics;
        private final TraceRequestMarshaler marshaler;
        private final AtomicBoolean loggedUnimplemented;
        private final ThrottlingLogger logger;
        private final String type;
        private final int numItems;
        private final CompletableResultCode result;
        private final int attemptNumber;

        public ClientRequestOnSuccessHandler(GrpcClient client, SocketAddress server, Map<String, String> headers, boolean compressionEnabled, ExporterMetrics exporterMetrics, TraceRequestMarshaler marshaler, AtomicBoolean loggedUnimplemented, ThrottlingLogger logger, String type, int numItems, CompletableResultCode result, int attemptNumber) {
            this.client = client;
            this.server = server;
            this.headers = headers;
            this.compressionEnabled = compressionEnabled;
            this.exporterMetrics = exporterMetrics;
            this.marshaler = marshaler;
            this.loggedUnimplemented = loggedUnimplemented;
            this.logger = logger;
            this.type = type;
            this.numItems = numItems;
            this.result = result;
            this.attemptNumber = attemptNumber;
        }

        public void handle(GrpcClientRequest<Buffer, Buffer> request) {
            if (this.compressionEnabled) {
                request.encoding("gzip");
            }
            request.serviceName(ServiceName.create((String)VertxGrpcExporter.GRPC_SERVICE_NAME));
            request.methodName(VertxGrpcExporter.GRPC_METHOD_NAME);
            if (!this.headers.isEmpty()) {
                MultiMap vertxHeaders = request.headers();
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    vertxHeaders.set(entry.getKey(), entry.getValue());
                }
            }
            try {
                int messageSize = this.marshaler.getBinarySerializedSize();
                Buffer buffer = Buffer.buffer((int)messageSize);
                BufferOutputStream os = new BufferOutputStream(buffer);
                this.marshaler.writeBinaryTo((OutputStream)os);
                request.send((Object)buffer).onSuccess((Handler)new Handler<GrpcClientResponse<Buffer, Buffer>>(){

                    public void handle(final GrpcClientResponse<Buffer, Buffer> response) {
                        response.exceptionHandler((Handler)new Handler<Throwable>(){

                            public void handle(Throwable t) {
                                if (attemptNumber <= 3) {
                                    VertxGrpcExporter.initiateSend(client, server, 3 - attemptNumber, this.newAttempt(), new Consumer<Throwable>(){

                                        @Override
                                        public void accept(Throwable throwable) {
                                            this.failOnClientRequest(numItems, throwable, result);
                                        }
                                    });
                                } else {
                                    exporterMetrics.addFailed((long)numItems);
                                    logger.log(Level.SEVERE, "Failed to export " + type + "s. The stream failed. Full error message: " + t.getMessage());
                                    result.fail();
                                }
                            }
                        }).errorHandler((Handler)new Handler<GrpcError>(){

                            public void handle(GrpcError error) {
                                this.handleError(error.status, (GrpcClientResponse<Buffer, Buffer>)response);
                            }
                        }).endHandler((Handler)new Handler<Void>(){

                            public void handle(Void ignored) {
                                GrpcStatus status = this.getStatus(response);
                                if (status == GrpcStatus.OK) {
                                    exporterMetrics.addSuccess((long)numItems);
                                    result.succeed();
                                } else {
                                    this.handleError(status, (GrpcClientResponse<Buffer, Buffer>)response);
                                }
                            }
                        });
                    }

                    private void handleError(GrpcStatus status, GrpcClientResponse<Buffer, Buffer> response) {
                        String statusMessage = this.getStatusMessage(response);
                        this.logAppropriateWarning(status, statusMessage);
                        exporterMetrics.addFailed((long)numItems);
                        result.fail();
                    }

                    private void logAppropriateWarning(GrpcStatus status, String statusMessage) {
                        if (status == GrpcStatus.UNIMPLEMENTED) {
                            if (loggedUnimplemented.compareAndSet(false, true)) {
                                this.logUnimplemented(internalLogger, type, statusMessage);
                            }
                        } else if (status == GrpcStatus.UNAVAILABLE) {
                            logger.log(Level.SEVERE, "Failed to export " + type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + statusMessage);
                        } else if (status == null) {
                            if (statusMessage == null) {
                                logger.log(Level.WARNING, "Failed to export " + type + "s. Perhaps the collector does not support collecting traces using grpc? Try configuring 'quarkus.otel.exporter.otlp.traces.protocol=http/protobuf'");
                            } else {
                                logger.log(Level.WARNING, "Failed to export " + type + "s. Server responded with error message: " + statusMessage);
                            }
                        } else {
                            logger.log(Level.WARNING, "Failed to export " + type + "s. Server responded with " + status.code + ". Error message: " + statusMessage);
                        }
                    }

                    private void logUnimplemented(Logger logger, String type, String fullErrorMessage) {
                        logger.log(Level.SEVERE, "Failed to export " + type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. If export is not desired and you are using OpenTelemetry autoconfiguration or the javaagent, disable export by setting " + (switch (type) {
                            case "span" -> "OTEL_TRACES_EXPORTER";
                            case "metric" -> "OTEL_METRICS_EXPORTER";
                            case "log" -> "OTEL_LOGS_EXPORTER";
                            default -> throw new IllegalStateException("Unrecognized type, this is a programming bug in the OpenTelemetry SDK");
                        }) + "=none. Full error message: " + fullErrorMessage);
                    }

                    private GrpcStatus getStatus(GrpcClientResponse<?, ?> response) {
                        String statusFromTrailer;
                        GrpcStatus result = response.status();
                        if (result == null && (statusFromTrailer = response.trailers().get(VertxGrpcExporter.GRPC_STATUS)) != null) {
                            result = GrpcStatus.valueOf((int)Integer.parseInt(statusFromTrailer));
                        }
                        return result;
                    }

                    private String getStatusMessage(GrpcClientResponse<Buffer, Buffer> response) {
                        String result = response.statusMessage();
                        if (result == null && (result = response.trailers().get(VertxGrpcExporter.GRPC_MESSAGE)) != null) {
                            result = QueryStringDecoder.decodeComponent((String)result, (Charset)StandardCharsets.UTF_8);
                        }
                        return result;
                    }
                }).onFailure((Handler)new Handler<Throwable>(){

                    public void handle(Throwable t) {
                        if (attemptNumber <= 3) {
                            VertxGrpcExporter.initiateSend(client, server, 3 - attemptNumber, this.newAttempt(), new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    this.failOnClientRequest(numItems, throwable, result);
                                }
                            });
                        } else {
                            exporterMetrics.addFailed((long)numItems);
                            logger.log(Level.SEVERE, "Failed to export " + type + "s. The request could not be executed. Full error message: " + t.getMessage());
                            result.fail();
                        }
                    }
                });
            }
            catch (IOException e) {
                this.exporterMetrics.addFailed((long)this.numItems);
                this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. Unable to serialize payload. Full error message: " + e.getMessage());
                this.result.fail();
            }
        }

        private void failOnClientRequest(int numItems, Throwable t, CompletableResultCode result) {
            this.exporterMetrics.addFailed((long)numItems);
            this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Full error message: " + t.getMessage());
            result.fail();
        }

        public ClientRequestOnSuccessHandler newAttempt() {
            return new ClientRequestOnSuccessHandler(this.client, this.server, this.headers, this.compressionEnabled, this.exporterMetrics, this.marshaler, this.loggedUnimplemented, this.logger, this.type, this.numItems, this.result, this.attemptNumber + 1);
        }
    }
}

