/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config.runtime.exporter;

import io.quarkus.opentelemetry.runtime.config.runtime.exporter.CompressionType;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public interface OtlpExporterTracesConfig {
    @WithDefault(value="http://localhost:4317/")
    public Optional<String> endpoint();

    @Deprecated
    @WithName(value="legacy-endpoint")
    @WithDefault(value="http://localhost:4317/")
    public Optional<String> legacyEndpoint();

    public Optional<List<String>> headers();

    public Optional<CompressionType> compression();

    @WithDefault(value="10s")
    public Duration timeout();

    @WithDefault(value="grpc")
    public Optional<String> protocol();

    @WithName(value="key-cert")
    public KeyCert keyCert();

    @WithName(value="trust-cert")
    public TrustCert trustCert();

    public Optional<String> tlsConfigurationName();

    public ProxyConfig proxyOptions();

    public static class Protocol {
        public static final String GRPC = "grpc";
        public static final String HTTP_PROTOBUF = "http/protobuf";
    }

    public static interface ProxyConfig {
        @WithDefault(value="false")
        public boolean enabled();

        public Optional<String> username();

        public Optional<String> password();

        public OptionalInt port();

        public Optional<String> host();
    }

    public static interface TrustCert {
        public Optional<List<String>> certs();
    }

    public static interface KeyCert {
        public Optional<List<String>> keys();

        public Optional<List<String>> certs();
    }
}

