/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.CompressionType;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterTracesConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.LateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterUtil;
import io.quarkus.opentelemetry.runtime.exporter.otlp.RemoveableLateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.exporter.otlp.VertxGrpcExporter;
import io.quarkus.opentelemetry.runtime.exporter.otlp.VertxHttpExporter;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.ProxyOptions;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class OTelExporterRecorder {
    public Function<SyntheticCreationalContext<LateBoundBatchSpanProcessor>, LateBoundBatchSpanProcessor> batchSpanProcessorForOtlp(final OTelRuntimeConfig otelRuntimeConfig, final OtlpExporterRuntimeConfig exporterRuntimeConfig, final Supplier<Vertx> vertx) {
        final URI baseUri = this.getBaseUri(exporterRuntimeConfig);
        return new Function<SyntheticCreationalContext<LateBoundBatchSpanProcessor>, LateBoundBatchSpanProcessor>(){

            @Override
            public LateBoundBatchSpanProcessor apply(SyntheticCreationalContext<LateBoundBatchSpanProcessor> context) {
                if (otelRuntimeConfig.sdkDisabled() || baseUri == null) {
                    return RemoveableLateBoundBatchSpanProcessor.INSTANCE;
                }
                Instance spanExporters = (Instance)context.getInjectedReference((TypeLiteral)new TypeLiteral<Instance<SpanExporter>>(){}, new Annotation[0]);
                if (!spanExporters.isUnsatisfied()) {
                    return RemoveableLateBoundBatchSpanProcessor.INSTANCE;
                }
                try {
                    TlsConfigurationRegistry tlsConfigurationRegistry = (TlsConfigurationRegistry)context.getInjectedReference(TlsConfigurationRegistry.class, new Annotation[0]);
                    SpanExporter spanExporter = this.createSpanExporter(exporterRuntimeConfig, (Vertx)vertx.get(), baseUri, tlsConfigurationRegistry);
                    BatchSpanProcessorBuilder processorBuilder = BatchSpanProcessor.builder((SpanExporter)spanExporter);
                    processorBuilder.setScheduleDelay(otelRuntimeConfig.bsp().scheduleDelay());
                    processorBuilder.setMaxQueueSize(otelRuntimeConfig.bsp().maxQueueSize().intValue());
                    processorBuilder.setMaxExportBatchSize(otelRuntimeConfig.bsp().maxExportBatchSize().intValue());
                    processorBuilder.setExporterTimeout(otelRuntimeConfig.bsp().exportTimeout());
                    return new LateBoundBatchSpanProcessor(processorBuilder.build());
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalStateException("Unable to install OTLP Exporter", iae);
                }
            }

            private SpanExporter createSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2, TlsConfigurationRegistry tlsConfigurationRegistry) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                if (tracesConfig.protocol().isEmpty()) {
                    throw new IllegalStateException("No OTLP protocol specified. Please check `quarkus.otel.exporter.otlp.traces.protocol` property");
                }
                String protocol = tracesConfig.protocol().get();
                if ("grpc".equals(protocol)) {
                    return this.createOtlpGrpcSpanExporter(exporterRuntimeConfig2, vertx2, baseUri2, tlsConfigurationRegistry);
                }
                if ("http/protobuf".equals(protocol)) {
                    return this.createHttpSpanExporter(exporterRuntimeConfig2, vertx2, baseUri2, protocol, tlsConfigurationRegistry);
                }
                throw new IllegalArgumentException(String.format("Unsupported OTLP protocol %s specified. Please check `quarkus.otel.exporter.otlp.traces.protocol` property", protocol));
            }

            private SpanExporter createOtlpGrpcSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2, TlsConfigurationRegistry tlsConfigurationRegistry) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                return new VertxGrpcExporter("otlp", "span", MeterProvider::noop, baseUri2, OTelExporterRecorder.determineCompression(tracesConfig), tracesConfig.timeout(), OTelExporterRecorder.populateTracingExportHttpHeaders(tracesConfig), new HttpClientOptionsConsumer(tracesConfig, baseUri2, tlsConfigurationRegistry), vertx2);
            }

            private SpanExporter createHttpSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2, String protocol, TlsConfigurationRegistry tlsConfigurationRegistry) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                boolean exportAsJson = false;
                return new VertxHttpExporter((HttpExporter<TraceRequestMarshaler>)new HttpExporter("otlp", "span", (HttpSender)new VertxHttpExporter.VertxHttpSender(baseUri2, OTelExporterRecorder.determineCompression(tracesConfig), tracesConfig.timeout(), OTelExporterRecorder.populateTracingExportHttpHeaders(tracesConfig), exportAsJson ? "application/json" : "application/x-protobuf", new HttpClientOptionsConsumer(tracesConfig, baseUri2, tlsConfigurationRegistry), vertx2), MeterProvider::noop, exportAsJson));
            }
        };
    }

    private static boolean determineCompression(OtlpExporterTracesConfig tracesConfig) {
        if (tracesConfig.compression().isPresent()) {
            return tracesConfig.compression().get() == CompressionType.GZIP;
        }
        return false;
    }

    private static Map<String, String> populateTracingExportHttpHeaders(OtlpExporterTracesConfig tracesConfig) {
        List<String> headers;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        OtlpUserAgent.addUserAgentHeader(headersMap::put);
        if (tracesConfig.headers().isPresent() && !(headers = tracesConfig.headers().get()).isEmpty()) {
            for (String header : headers) {
                if (header.isEmpty()) continue;
                String[] parts = header.split("=", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                headersMap.put(key, value);
            }
        }
        return headersMap;
    }

    private URI getBaseUri(OtlpExporterRuntimeConfig exporterRuntimeConfig) {
        String endpoint = OTelExporterRecorder.resolveEndpoint(exporterRuntimeConfig).trim();
        if (endpoint.isEmpty()) {
            return null;
        }
        return ExporterBuilderUtil.validateEndpoint((String)endpoint);
    }

    static String resolveEndpoint(OtlpExporterRuntimeConfig runtimeConfig) {
        String endpoint = runtimeConfig.traces().legacyEndpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.traces().endpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.endpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse("http://localhost:4317/")));
        return endpoint.trim();
    }

    private static boolean excludeDefaultEndpoint(String endpoint) {
        return !"http://localhost:4317/".equals(endpoint);
    }

    static class HttpClientOptionsConsumer
    implements Consumer<HttpClientOptions> {
        private final OtlpExporterTracesConfig tracesConfig;
        private final URI baseUri;
        private final Optional<TlsConfiguration> maybeTlsConfiguration;
        private final TlsConfigurationRegistry tlsConfigurationRegistry;

        public HttpClientOptionsConsumer(OtlpExporterTracesConfig tracesConfig, URI baseUri, TlsConfigurationRegistry tlsConfigurationRegistry) {
            this.tracesConfig = tracesConfig;
            this.baseUri = baseUri;
            this.maybeTlsConfiguration = TlsConfiguration.from((TlsConfigurationRegistry)tlsConfigurationRegistry, tracesConfig.tlsConfigurationName());
            this.tlsConfigurationRegistry = tlsConfigurationRegistry;
        }

        @Override
        public void accept(HttpClientOptions options) {
            this.configureTLS(options);
            if (this.tracesConfig.proxyOptions().enabled()) {
                this.configureProxyOptions(options);
            }
        }

        private void configureTLS(HttpClientOptions options) {
            boolean trustAll;
            this.configureKeyCertOptions(options);
            this.configureTrustOptions(options);
            if (OTelExporterUtil.isHttps(this.baseUri)) {
                options.setSsl(true);
                options.setUseAlpn(true);
            }
            if (trustAll = this.maybeTlsConfiguration.map(TlsConfiguration::isTrustAll).orElseGet(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return tlsConfigurationRegistry.getDefault().map(TlsConfiguration::isTrustAll).orElse(false);
                }
            }).booleanValue()) {
                options.setTrustAll(true);
                options.setVerifyHost(false);
            }
        }

        private void configureProxyOptions(HttpClientOptions options) {
            OtlpExporterTracesConfig.ProxyConfig proxyConfig = this.tracesConfig.proxyOptions();
            Optional<String> proxyHost = proxyConfig.host();
            if (proxyHost.isPresent()) {
                ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost.get());
                if (proxyConfig.port().isPresent()) {
                    proxyOptions.setPort(proxyConfig.port().getAsInt());
                }
                if (proxyConfig.username().isPresent()) {
                    proxyOptions.setUsername(proxyConfig.username().get());
                }
                if (proxyConfig.password().isPresent()) {
                    proxyOptions.setPassword(proxyConfig.password().get());
                }
                options.setProxyOptions(proxyOptions);
            } else {
                this.configureProxyOptionsFromJDKSysProps(options);
            }
        }

        private void configureProxyOptionsFromJDKSysProps(HttpClientOptions options) {
            String proxyHost = options.isSsl() ? System.getProperty("https.proxyHost", "none") : System.getProperty("http.proxyHost", "none");
            String proxyPortAsString = options.isSsl() ? System.getProperty("https.proxyPort", "443") : System.getProperty("http.proxyPort", "80");
            int proxyPort = Integer.parseInt(proxyPortAsString);
            if (!"none".equals(proxyHost)) {
                String proxyPassword;
                String proxyUser;
                ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost).setPort(proxyPort);
                String string = proxyUser = options.isSsl() ? System.getProperty("https.proxyUser") : System.getProperty("http.proxyUser");
                if (proxyUser != null && !proxyUser.isBlank()) {
                    proxyOptions.setUsername(proxyUser);
                }
                String string2 = proxyPassword = options.isSsl() ? System.getProperty("https.proxyPassword") : System.getProperty("http.proxyPassword");
                if (proxyPassword != null && !proxyPassword.isBlank()) {
                    proxyOptions.setPassword(proxyPassword);
                }
                options.setProxyOptions(proxyOptions);
            }
        }

        private void configureKeyCertOptions(HttpClientOptions options) {
            if (this.maybeTlsConfiguration.isPresent()) {
                options.setKeyCertOptions(this.maybeTlsConfiguration.get().getKeyStoreOptions());
                return;
            }
            OtlpExporterTracesConfig.KeyCert keyCert = this.tracesConfig.keyCert();
            if (keyCert.certs().isEmpty() && keyCert.keys().isEmpty()) {
                return;
            }
            PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
            if (keyCert.certs().isPresent()) {
                for (String cert : keyCert.certs().get()) {
                    pemKeyCertOptions.addCertPath(cert);
                }
            }
            if (keyCert.keys().isPresent()) {
                for (String cert : keyCert.keys().get()) {
                    pemKeyCertOptions.addKeyPath(cert);
                }
            }
            options.setKeyCertOptions((KeyCertOptions)pemKeyCertOptions);
        }

        private void configureTrustOptions(HttpClientOptions options) {
            List<String> certs;
            if (this.maybeTlsConfiguration.isPresent()) {
                options.setTrustOptions(this.maybeTlsConfiguration.get().getTrustStoreOptions());
                return;
            }
            OtlpExporterTracesConfig.TrustCert trustCert = this.tracesConfig.trustCert();
            if (trustCert.certs().isPresent() && !(certs = trustCert.certs().get()).isEmpty()) {
                PemTrustOptions pemTrustOptions = new PemTrustOptions();
                for (String cert : trustCert.certs().get()) {
                    pemTrustOptions.addCertPath(cert);
                }
                options.setPemTrustOptions(pemTrustOptions);
            }
        }
    }
}

