/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.logs;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.semconv.ExceptionAttributes;
import io.opentelemetry.semconv.incubating.CodeIncubatingAttributes;
import io.opentelemetry.semconv.incubating.LogIncubatingAttributes;
import io.opentelemetry.semconv.incubating.ThreadIncubatingAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class OpenTelemetryLogHandler
extends ExtHandler {
    private final OpenTelemetry openTelemetry;

    public OpenTelemetryLogHandler(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    protected void doPublish(ExtLogRecord record) {
        if (this.openTelemetry == null) {
            return;
        }
        LogRecordBuilder logRecordBuilder = this.openTelemetry.getLogsBridge().loggerBuilder("io.quarkus.opentelemetry").build().logRecordBuilder().setTimestamp(Instant.now()).setObservedTimestamp(record.getInstant());
        if (record.getLevel() != null) {
            logRecordBuilder.setSeverity(this.mapSeverity(record.getLevel())).setSeverityText(record.getLevel().getName());
        }
        if (record.getMessage() != null) {
            Formatter formatter = this.getFormatter();
            String logMsg = formatter != null ? formatter.format((LogRecord)record) : record.getFormattedMessage();
            logRecordBuilder.setBody(logMsg);
        }
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(CodeIncubatingAttributes.CODE_NAMESPACE, (Object)record.getSourceClassName());
        attributes.put(CodeIncubatingAttributes.CODE_FUNCTION, (Object)record.getSourceMethodName());
        attributes.put(CodeIncubatingAttributes.CODE_LINENO, record.getSourceLineNumber());
        attributes.put(ThreadIncubatingAttributes.THREAD_NAME, (Object)record.getThreadName());
        attributes.put(ThreadIncubatingAttributes.THREAD_ID, (Object)record.getLongThreadID());
        attributes.put(AttributeKey.stringKey((String)"log.logger.namespace"), (Object)record.getLoggerClassName());
        Map mdcCopy = record.getMdcCopy();
        if (mdcCopy != null) {
            mdcCopy.forEach((k, v) -> {
                if (!(k.equalsIgnoreCase("spanid") || k.equalsIgnoreCase("traceid") || k.equalsIgnoreCase("sampled"))) {
                    attributes.put(AttributeKey.stringKey((String)k), v);
                }
            });
        }
        if (record.getThrown() != null) {
            try (StringWriter sw = new StringWriter(1024);
                 PrintWriter pw = new PrintWriter(sw);){
                record.getThrown().printStackTrace(pw);
                sw.flush();
                attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)sw.toString());
            }
            catch (Throwable t) {
                attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)"Unable to get the stacktrace of the exception");
            }
            attributes.put(ExceptionAttributes.EXCEPTION_TYPE, (Object)record.getThrown().getClass().getName());
            attributes.put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)record.getThrown().getMessage());
        }
        Config config = ConfigProvider.getConfig();
        config.getOptionalValue("quarkus.log.file.enable", Boolean.class).ifPresent(enable -> {
            Optional filePath = config.getOptionalValue("quarkus.log.file.path", String.class);
            if (enable.equals(Boolean.TRUE) && filePath.isPresent()) {
                attributes.put(LogIncubatingAttributes.LOG_FILE_PATH, (Object)((String)filePath.get()));
            }
        });
        logRecordBuilder.setAllAttributes(attributes.build());
        logRecordBuilder.emit();
    }

    private Severity mapSeverity(Level level) {
        if (level.intValue() == Level.SEVERE.intValue()) {
            return Severity.ERROR;
        }
        if (level.intValue() == Level.WARNING.intValue()) {
            return Severity.WARN;
        }
        if (level.intValue() <= Level.INFO.intValue() && level.intValue() >= Level.CONFIG.intValue()) {
            return Severity.INFO;
        }
        if (level.intValue() == Level.FINE.intValue()) {
            return Severity.DEBUG;
        }
        if (level.intValue() <= Level.FINER.intValue()) {
            return Severity.TRACE;
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

