/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config;

import io.quarkus.opentelemetry.runtime.config.build.LegacySamplerNameConverter;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import jakarta.annotation.Priority;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

@Priority(value=3305)
public class OTelFallbackConfigSourceInterceptor
extends FallbackConfigSourceInterceptor {
    private static final Map<String, String> FALLBACKS = new HashMap<String, String>();
    private static final LegacySamplerNameConverter LEGACY_SAMPLER_NAME_CONVERTER = new LegacySamplerNameConverter();

    public OTelFallbackConfigSourceInterceptor() {
        super(FALLBACKS);
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue value = super.getValue(context, name);
        if (name.equals("quarkus.otel.traces.sampler")) {
            return value.withValue(LEGACY_SAMPLER_NAME_CONVERTER.convert(value.getValue()));
        }
        return value;
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            String fallback = FALLBACKS.get(name);
            if (fallback != null) {
                ConfigValue nameValue = context.proceed(name);
                ConfigValue fallbackValue = context.proceed(fallback);
                if (nameValue == null) {
                    names.add(fallback);
                    continue;
                }
                if (fallbackValue == null) {
                    names.add(name);
                    continue;
                }
                if (nameValue.getConfigSourceOrdinal() >= fallbackValue.getConfigSourceOrdinal()) {
                    names.add(name);
                    continue;
                }
                names.add(fallback);
                continue;
            }
            names.add(name);
        }
        return names.iterator();
    }

    static {
        FALLBACKS.put("quarkus.otel.enabled", "quarkus.opentelemetry.enabled");
        FALLBACKS.put("quarkus.otel.traces.enabled", "quarkus.opentelemetry.tracer.enabled");
        FALLBACKS.put("quarkus.otel.propagators", "quarkus.opentelemetry.propagators");
        FALLBACKS.put("quarkus.otel.resource.attributes", "quarkus.opentelemetry.tracer.resource-attributes");
        FALLBACKS.put("quarkus.otel.traces.suppress-non-application-uris", "quarkus.opentelemetry.tracer.suppress-non-application-uris");
        FALLBACKS.put("quarkus.otel.traces.include-static-resources", "quarkus.opentelemetry.tracer.include-static-resources");
        FALLBACKS.put("quarkus.otel.traces.sampler", "quarkus.opentelemetry.tracer.sampler");
        FALLBACKS.put("quarkus.otel.traces.sampler.arg", "quarkus.opentelemetry.tracer.sampler.ratio");
        FALLBACKS.put("quarkus.otel.exporter.otlp.enabled", "quarkus.opentelemetry.tracer.exporter.otlp.enabled");
        FALLBACKS.put("quarkus.otel.exporter.otlp.traces.legacy-endpoint", "quarkus.opentelemetry.tracer.exporter.otlp.endpoint");
        FALLBACKS.put("quarkus.otel.exporter.otlp.traces.headers", "quarkus.opentelemetry.tracer.exporter.otlp.headers");
    }
}

