/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;

@ApplicationScoped
public class EndUserSpanProcessor
implements SpanProcessor {
    @Inject
    protected SecurityIdentity securityIdentity;
    @Inject
    protected ManagedExecutor managedExecutor;

    @ActivateRequestContext
    public void onStart(Context parentContext, ReadWriteSpan span) {
        this.managedExecutor.execute(() -> span.setAllAttributes(this.securityIdentity.isAnonymous() ? Attributes.empty() : Attributes.of((AttributeKey)SemanticAttributes.ENDUSER_ID, (Object)this.securityIdentity.getPrincipal().getName(), (AttributeKey)SemanticAttributes.ENDUSER_ROLE, (Object)this.securityIdentity.getRoles().toString())));
    }

    public boolean isStartRequired() {
        return Boolean.TRUE;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return Boolean.FALSE;
    }
}

