/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Recorder
public class TracerRecorder {
    public static final Set<String> dropNonApplicationUriTargets = new HashSet<String>();
    public static final Set<String> dropStaticResourceTargets = new HashSet<String>();

    public void setAttributes(BeanContainer beanContainer, String quarkusVersion, String serviceName, String serviceVersion) {
        DelayedAttributes delayedAttributes = (DelayedAttributes)beanContainer.beanInstance(DelayedAttributes.class, new Annotation[0]);
        delayedAttributes.setAttributesDelegate(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ResourceAttributes.SERVICE_VERSION, (Object)serviceVersion, (AttributeKey)ResourceAttributes.WEBENGINE_NAME, (Object)"Quarkus", (AttributeKey)ResourceAttributes.WEBENGINE_VERSION, (Object)quarkusVersion))).getAttributes());
    }

    public void setupSampler(List<String> dropNonApplicationUris, List<String> dropStaticResources) {
        dropNonApplicationUriTargets.addAll(dropNonApplicationUris);
        dropStaticResourceTargets.addAll(dropStaticResources);
    }
}

