/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.List;

public class DropTargetsSampler
implements Sampler {
    private final Sampler sampler;
    private final List<String> dropTargets;

    public DropTargetsSampler(Sampler sampler, List<String> dropTargets) {
        this.sampler = sampler;
        this.dropTargets = dropTargets;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        String target;
        if (spanKind.equals((Object)SpanKind.SERVER) && this.shouldDrop(target = (String)attributes.get(SemanticAttributes.HTTP_TARGET))) {
            return SamplingResult.drop();
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    private boolean shouldDrop(String target) {
        if (target == null || target.isEmpty()) {
            return false;
        }
        if (this.safeContains(target)) {
            return true;
        }
        if (target.charAt(target.length() - 1) == '/' && this.safeContains(target.substring(0, target.length() - 1))) {
            return true;
        }
        int lastSlashIndex = target.lastIndexOf(47);
        return lastSlashIndex != -1 && (this.safeContains(target.substring(0, lastSlashIndex) + "*") || this.safeContains(target.substring(0, lastSlashIndex) + "/*"));
    }

    private boolean safeContains(String target) {
        return this.dropTargets.contains(target);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

