/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.All;
import io.quarkus.opentelemetry.TextMapPropagatorCustomizer;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.RemoveableLateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.tracing.DropTargetsSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerUtil;
import io.quarkus.runtime.ApplicationConfig;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

public interface AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
    public void customize(AutoConfiguredOpenTelemetrySdkBuilder var1);

    @Singleton
    public static final class TextMapPropagatorCustomizers
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final List<TextMapPropagatorCustomizer> customizers;

        public TextMapPropagatorCustomizers(@All List<TextMapPropagatorCustomizer> customizers) {
            this.customizers = customizers;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            for (final TextMapPropagatorCustomizer customizer : this.customizers) {
                builder.addPropagatorCustomizer((BiFunction)new BiFunction<TextMapPropagator, ConfigProperties, TextMapPropagator>(){

                    @Override
                    public TextMapPropagator apply(final TextMapPropagator textMapPropagator, final ConfigProperties configProperties) {
                        return customizer.customize(new TextMapPropagatorCustomizer.Context(){

                            @Override
                            public TextMapPropagator propagator() {
                                return textMapPropagator;
                            }

                            @Override
                            public ConfigProperties otelConfigProperties() {
                                return configProperties;
                            }
                        });
                    }
                });
            }
        }
    }

    @Singleton
    public static final class TracerProviderCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final OTelBuildConfig oTelBuildConfig;
        private final List<IdGenerator> idGenerator;
        private final List<SpanProcessor> spanProcessors;

        public TracerProviderCustomizer(OTelBuildConfig oTelBuildConfig, @All List<IdGenerator> idGenerator, @All List<SpanProcessor> spanProcessors) {
            this.oTelBuildConfig = oTelBuildConfig;
            this.idGenerator = idGenerator;
            this.spanProcessors = spanProcessors;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addTracerProviderCustomizer((BiFunction)new BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder>(){

                @Override
                public SdkTracerProviderBuilder apply(SdkTracerProviderBuilder builder, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        idGenerator.stream().findFirst().ifPresent(arg_0 -> ((SdkTracerProviderBuilder)builder).setIdGenerator(arg_0));
                        spanProcessors.stream().filter(sp -> !(sp instanceof RemoveableLateBoundBatchSpanProcessor)).forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
                    }
                    return builder;
                }
            });
        }
    }

    @Singleton
    public static final class SamplerCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final OTelBuildConfig oTelBuildConfig;
        private final OTelRuntimeConfig oTelRuntimeConfig;
        private final List<Sampler> sampler;

        public SamplerCustomizer(OTelBuildConfig oTelBuildConfig, OTelRuntimeConfig oTelRuntimeConfig, @All List<Sampler> sampler) {
            this.oTelBuildConfig = oTelBuildConfig;
            this.oTelRuntimeConfig = oTelRuntimeConfig;
            this.sampler = sampler;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addSamplerCustomizer((BiFunction)new BiFunction<Sampler, ConfigProperties, Sampler>(){

                @Override
                public Sampler apply(Sampler existingSampler, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        Sampler effectiveSampler = sampler.stream().findFirst().map(Sampler.class::cast).orElse(existingSampler);
                        ArrayList<String> dropTargets = new ArrayList<String>();
                        if (oTelRuntimeConfig.traces().suppressNonApplicationUris().booleanValue()) {
                            dropTargets.addAll(TracerRecorder.dropNonApplicationUriTargets);
                        }
                        if (!oTelRuntimeConfig.traces().includeStaticResources().booleanValue()) {
                            dropTargets.addAll(TracerRecorder.dropStaticResourceTargets);
                        }
                        if (!dropTargets.isEmpty()) {
                            return new DropTargetsSampler(effectiveSampler, dropTargets);
                        }
                        return effectiveSampler;
                    }
                    return Sampler.alwaysOff();
                }
            });
        }
    }

    @Singleton
    public static final class ResourceCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final ApplicationConfig appConfig;
        private final OTelBuildConfig oTelBuildConfig;
        private final OTelRuntimeConfig oTelRuntimeConfig;
        private final Instance<DelayedAttributes> delayedAttributes;
        private final List<Resource> resources;

        public ResourceCustomizer(ApplicationConfig appConfig, OTelBuildConfig oTelBuildConfig, OTelRuntimeConfig oTelRuntimeConfig, @Any Instance<DelayedAttributes> delayedAttributes, @All List<Resource> resources) {
            this.appConfig = appConfig;
            this.oTelBuildConfig = oTelBuildConfig;
            this.oTelRuntimeConfig = oTelRuntimeConfig;
            this.delayedAttributes = delayedAttributes;
            this.resources = resources;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addResourceCustomizer((BiFunction)new BiFunction<Resource, ConfigProperties, Resource>(){

                @Override
                public Resource apply(Resource existingResource, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        Resource consolidatedResource = existingResource.merge(Resource.create((Attributes)((Attributes)delayedAttributes.get())));
                        String serviceName = oTelRuntimeConfig.serviceName().filter(sn -> !sn.equals(appConfig.name.orElse("unset"))).orElse(null);
                        String hostname = null;
                        try {
                            hostname = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException e) {
                            hostname = "unknown";
                        }
                        Resource resource = resources.stream().reduce(Resource.empty(), Resource::merge).merge(TracerUtil.mapResourceAttributes(oTelRuntimeConfig.resourceAttributes().orElse(Collections.emptyList()), serviceName, hostname));
                        return consolidatedResource.merge(resource);
                    }
                    return Resource.builder().build();
                }
            });
        }
    }
}

