/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.semconv.SemanticAttributes;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.logging.Logger;

@ApplicationScoped
public class EndUserSpanProcessor
implements SpanProcessor {
    private static final Logger LOG = Logger.getLogger(EndUserSpanProcessor.class);
    @Inject
    protected SecurityIdentity securityIdentity;
    @Inject
    protected ManagedExecutor managedExecutor;

    @ActivateRequestContext
    public void onStart(Context parentContext, ReadWriteSpan span) {
        this.managedExecutor.execute(() -> {
            try {
                if (!span.isRecording()) {
                    LOG.debug((Object)("Failed to set end user attributes on spanId:" + span.getSpanContext().getSpanId() + " Span not recording"));
                    return;
                }
                ManagedContext managedContext = Arc.container().requestContext();
                if (!managedContext.isActive()) {
                    LOG.debug((Object)("Failed to set end user attributes on span.spanId:" + span.getSpanContext().getSpanId() + " Request Context not active"));
                    return;
                }
                span.setAllAttributes(this.securityIdentity.isAnonymous() ? Attributes.empty() : Attributes.of((AttributeKey)SemanticAttributes.ENDUSER_ID, (Object)this.securityIdentity.getPrincipal().getName(), (AttributeKey)SemanticAttributes.ENDUSER_ROLE, (Object)this.securityIdentity.getRoles().toString()));
            }
            catch (Exception e) {
                LOG.debug((Object)"Failed to set end user attributes on span", (Throwable)e);
            }
        });
    }

    public boolean isStartRequired() {
        return Boolean.TRUE;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return Boolean.FALSE;
    }
}

