/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.panache.common.deployment.JandexUtil;
import java.util.List;
import java.util.function.BiFunction;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheRepositoryEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final DotName OBJECT_DOT_NAME = DotName.createSimple((String)Object.class.getName());
    protected final ClassInfo panacheRepositoryBaseClassInfo;
    protected final IndexView indexView;

    public PanacheRepositoryEnhancer(IndexView index, DotName panacheRepositoryBaseName) {
        this.panacheRepositoryBaseClassInfo = index.getClassByName(panacheRepositoryBaseName);
        this.indexView = index;
    }

    @Override
    public abstract ClassVisitor apply(String var1, ClassVisitor var2);

    protected static abstract class PanacheRepositoryClassVisitor
    extends ClassVisitor {
        protected org.objectweb.asm.Type entityType;
        protected String entitySignature;
        protected String entityBinaryType;
        protected String daoBinaryName;
        protected ClassInfo panacheRepositoryBaseClassInfo;
        protected IndexView indexView;

        public PanacheRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, ClassInfo panacheRepositoryBaseClassInfo, IndexView indexView) {
            super(458752, outputClassVisitor);
            this.daoBinaryName = className.replace('.', '/');
            this.panacheRepositoryBaseClassInfo = panacheRepositoryBaseClassInfo;
            this.indexView = indexView;
        }

        protected abstract DotName getPanacheRepositoryDotName();

        protected abstract DotName getPanacheRepositoryBaseDotName();

        protected abstract String getPanacheOperationsBinaryName();

        protected abstract String getModelDescriptor();

        protected abstract void injectModel(MethodVisitor var1);

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String repositoryClassName = name.replace('/', '.');
            String foundEntityType = this.findEntityBinaryTypeForPanacheRepository(repositoryClassName, this.getPanacheRepositoryDotName());
            if (foundEntityType == null) {
                foundEntityType = this.findEntityBinaryTypeForPanacheRepository(repositoryClassName, this.getPanacheRepositoryBaseDotName());
            }
            this.entityBinaryType = foundEntityType;
            this.entitySignature = "L" + this.entityBinaryType + ";";
            this.entityType = org.objectweb.asm.Type.getType((String)this.entitySignature);
        }

        private String findEntityBinaryTypeForPanacheRepository(String repositoryClassName, DotName repositoryDotName) {
            for (ClassInfo classInfo : this.indexView.getAllKnownImplementors(repositoryDotName)) {
                if (!repositoryClassName.equals(classInfo.name().toString())) continue;
                return this.recursivelyFindEntityTypeFromClass(classInfo.name(), repositoryDotName);
            }
            return null;
        }

        private String recursivelyFindEntityTypeFromClass(DotName clazz, DotName repositoryDotName) {
            if (clazz.equals((Object)OBJECT_DOT_NAME)) {
                return null;
            }
            ClassInfo classByName = this.indexView.getClassByName(clazz);
            for (Type type : classByName.interfaceTypes()) {
                if (!type.name().equals((Object)repositoryDotName)) continue;
                Type entityType = (Type)type.asParameterizedType().arguments().get(0);
                return entityType.name().toString().replace('.', '/');
            }
            return this.recursivelyFindEntityTypeFromClass(classByName.superName(), repositoryDotName);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        public void visitEnd() {
            for (MethodInfo method : this.panacheRepositoryBaseClassInfo.methods()) {
                AnnotationInstance bridge = method.annotation(JandexUtil.DOTNAME_GENERATE_BRIDGE);
                if (bridge == null) continue;
                this.generateMethod(method, bridge.value("targetReturnTypeErased"));
            }
            super.visitEnd();
        }

        private void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased) {
            int i;
            String descriptor = JandexUtil.getDescriptor(method, name -> name.equals("Entity") ? this.entitySignature : null);
            String signature = JandexUtil.getSignature(method, name -> name.equals("Entity") ? this.entitySignature : null);
            List parameters = method.parameters();
            String castTo = null;
            if (targetReturnTypeErased != null && targetReturnTypeErased.asBoolean()) {
                Type type = method.returnType();
                if (type.kind() == Type.Kind.TYPE_VARIABLE && type.asTypeVariable().identifier().equals("Entity")) {
                    castTo = this.entityBinaryType;
                }
                if (castTo == null) {
                    castTo = type.name().toString('/');
                }
            }
            MethodVisitor mv = super.visitMethod(4097, method.name(), descriptor, signature, null);
            for (i = 0; i < parameters.size(); ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
            mv.visitCode();
            this.injectModel(mv);
            for (i = 0; i < parameters.size(); ++i) {
                mv.visitIntInsn(25, i + 1);
            }
            String forwardingDescriptor = "(" + this.getModelDescriptor() + descriptor.substring(1);
            if (castTo != null) {
                int lastParen = forwardingDescriptor.lastIndexOf(41);
                forwardingDescriptor = forwardingDescriptor.substring(0, lastParen + 1) + "Ljava/lang/Object;";
            }
            mv.visitMethodInsn(184, this.getPanacheOperationsBinaryName(), method.name(), forwardingDescriptor, false);
            if (castTo != null) {
                mv.visitTypeInsn(192, castTo);
            }
            String returnTypeDescriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
            mv.visitInsn(JandexUtil.getReturnInstruction(returnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }
}

