/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheFieldAccessMethodVisitor;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerVisitor;
import io.quarkus.panache.common.deployment.PanacheMovingAnnotationVisitor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheEntityClassVisitor<EntityFieldType extends EntityField>
extends ClassVisitor {
    protected org.objectweb.asm.Type thisClass;
    protected final Map<String, ? extends EntityFieldType> fields;
    private final Set<String> userMethods = new HashSet<String>();
    private final MetamodelInfo<?> modelInfo;
    protected final ClassInfo panacheEntityBaseClassInfo;
    protected ClassInfo entityInfo;
    protected List<PanacheMethodCustomizer> methodCustomizers;

    public PanacheEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<? extends EntityModel<? extends EntityFieldType>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
        super(589824, outputClassVisitor);
        this.thisClass = org.objectweb.asm.Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.modelInfo = modelInfo;
        EntityModel<? extends EntityFieldType> entityModel = modelInfo.getEntityModel(className);
        this.fields = entityModel != null ? entityModel.fields : null;
        this.panacheEntityBaseClassInfo = panacheEntityBaseClassInfo;
        this.entityInfo = entityInfo;
        this.methodCustomizers = methodCustomizers;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        final EntityField ef = (EntityField)this.fields.get(name);
        if (ef == null) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        FieldVisitor superVisitor = name.equals("id") ? super.visitField(access, name, descriptor, signature, value) : super.visitField((access | 4) & 0xFFFFFFFC, name, descriptor, signature, value);
        ef.signature = signature;
        return new FieldVisitor(589824, superVisitor){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (!descriptor.startsWith("Ljavax/xml/bind/annotation/")) {
                    return super.visitAnnotation(descriptor, visible);
                }
                EntityField.EntityFieldAnnotation efAnno = new EntityField.EntityFieldAnnotation(descriptor);
                ef.annotations.add(efAnno);
                return new PanacheMovingAnnotationVisitor(efAnno);
            }

            public void visitEnd() {
                super.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
                super.visitEnd();
            }
        };
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        MethodVisitor superVisitor = super.visitMethod(access, methodName, descriptor, signature, exceptions);
        if (Modifier.isStatic(access) && Modifier.isPublic(access) && (access & 0x1000) == 0 && !this.methodCustomizers.isEmpty()) {
            Object[] argTypes = AsmUtil.getParameterTypes((String)descriptor);
            MethodInfo method = this.entityInfo.method(methodName, (Type[])argTypes);
            if (method == null) {
                throw new IllegalStateException("Could not find indexed method: " + this.thisClass + "." + methodName + " with descriptor " + descriptor + " and arg types " + Arrays.toString(argTypes));
            }
            superVisitor = new PanacheMethodCustomizerVisitor(superVisitor, method, this.thisClass, this.methodCustomizers);
        }
        return new PanacheFieldAccessMethodVisitor(superVisitor, this.thisClass.getInternalName(), methodName, descriptor, this.modelInfo);
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheEntityBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateMethod(method, bridge.value("targetReturnTypeErased"));
        }
        this.generateAccessors();
        super.visitEnd();
    }

    protected void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased) {
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
        String signature = AsmUtil.getSignature((MethodInfo)method, name -> null);
        List parameters = method.parameters();
        String castTo = null;
        if (targetReturnTypeErased != null && targetReturnTypeErased.asBoolean()) {
            castTo = method.returnType().name().toString('/');
        }
        MethodVisitor mv = super.visitMethod(4105, method.name(), descriptor, signature, null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            customizer.customize(this.thisClass, method, mv);
        }
        this.injectModel(mv);
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i);
        }
        String forwardingDescriptor = "(" + this.getModelDescriptor() + descriptor.substring(1);
        if (castTo != null) {
            int lastParen = forwardingDescriptor.lastIndexOf(41);
            forwardingDescriptor = forwardingDescriptor.substring(0, lastParen + 1) + "Ljava/lang/Object;";
        }
        this.invokeOperation(method, mv, forwardingDescriptor);
        if (castTo != null) {
            mv.visitTypeInsn(192, castTo);
        }
        String returnTypeDescriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        mv.visitInsn(AsmUtil.getReturnInstruction((String)returnTypeDescriptor));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokeOperation(MethodInfo method, MethodVisitor mv, String forwardingDescriptor) {
        mv.visitMethodInsn(184, this.getPanacheOperationsInternalName(), method.name(), forwardingDescriptor, false);
    }

    protected String getModelDescriptor() {
        return "Ljava/lang/Class;";
    }

    protected abstract String getPanacheOperationsInternalName();

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.thisClass);
    }

    protected void generateAccessors() {
        if (this.fields == null) {
            return;
        }
        for (EntityField field : this.fields.values()) {
            int loadCode;
            String getterName = field.getGetterName();
            String getterDescriptor = "()" + field.descriptor;
            if (!this.userMethods.contains(getterName + "/" + getterDescriptor)) {
                MethodVisitor mv = super.visitMethod(1, getterName, getterDescriptor, field.signature == null ? null : "()" + field.signature, null);
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                this.generateAccessorGetField(mv, field);
                int returnCode = AsmUtil.getReturnInstruction((String)field.descriptor);
                mv.visitInsn(returnCode);
                mv.visitMaxs(0, 0);
                for (EntityField.EntityFieldAnnotation anno : field.annotations) {
                    anno.writeToVisitor(mv);
                }
                if (this.shouldAddJsonProperty(field)) {
                    AnnotationValue jsonPropertyValue;
                    AnnotationInstance jsonPropertyInstance;
                    AnnotationVisitor visitor = mv.visitAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;", true);
                    FieldInfo fieldInfo = this.entityInfo.field(field.name);
                    if (fieldInfo != null && (jsonPropertyInstance = fieldInfo.annotation(PanacheEntityEnhancer.JSON_PROPERTY_DOT_NAME)) != null && (jsonPropertyValue = jsonPropertyInstance.value()) != null && !jsonPropertyValue.asString().isEmpty()) {
                        visitor.visit("value", (Object)jsonPropertyValue.asString());
                    }
                    visitor.visitEnd();
                }
                mv.visitEnd();
            }
            String setterName = field.getSetterName();
            String setterDescriptor = "(" + field.descriptor + ")V";
            if (this.userMethods.contains(setterName + "/" + setterDescriptor)) continue;
            MethodVisitor mv = super.visitMethod(1, setterName, setterDescriptor, field.signature == null ? null : "(" + field.signature + ")V", null);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            switch (field.descriptor) {
                case "Z": 
                case "B": 
                case "C": 
                case "S": 
                case "I": {
                    loadCode = 21;
                    break;
                }
                case "J": {
                    loadCode = 22;
                    break;
                }
                case "F": {
                    loadCode = 23;
                    break;
                }
                case "D": {
                    loadCode = 24;
                    break;
                }
                default: {
                    loadCode = 25;
                }
            }
            mv.visitIntInsn(loadCode, 1);
            this.generateAccessorSetField(mv, field);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private boolean shouldAddJsonProperty(EntityField entityField) {
        if (this.isAnnotatedWithJsonIgnore(entityField)) {
            return false;
        }
        return !entityField.hasAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;");
    }

    private boolean isAnnotatedWithJsonIgnore(EntityField entityField) {
        FieldInfo field = this.entityInfo.field(entityField.name);
        if (field != null) {
            return field.hasAnnotation(PanacheEntityEnhancer.JSON_IGNORE_DOT_NAME);
        }
        return false;
    }

    protected abstract void generateAccessorSetField(MethodVisitor var1, EntityField var2);

    protected abstract void generateAccessorGetField(MethodVisitor var1, EntityField var2);
}

