/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.visitors.KotlinPanacheClassVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheRepositoryClassVisitor
extends ClassVisitor {
    public static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    protected org.objectweb.asm.Type entityType;
    protected String entitySignature;
    protected String daoBinaryName;
    protected ClassInfo daoClassInfo;
    protected ClassInfo panacheRepositoryBaseClassInfo;
    protected IndexView indexView;
    protected Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    protected Set<String> userMethods = new HashSet<String>();
    private final TypeBundle typeBundle;
    protected Function<String, String> argMapper;
    protected ByteCodeType entityUpperBound;
    private final Map<String, String> erasures = new HashMap<String, String>();

    public PanacheRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, IndexView indexView, TypeBundle typeBundle) {
        super(589824, outputClassVisitor);
        this.typeBundle = typeBundle;
        this.daoClassInfo = indexView.getClassByName(DotName.createSimple((String)className));
        this.daoBinaryName = className.replace('.', '/');
        this.indexView = indexView;
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.entityType);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        DotName baseType = this.typeBundle.repositoryBase().dotName();
        List typeVariables = this.indexView.getClassByName(baseType).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : KotlinPanacheClassVisitor.OBJECT;
        this.discoverTypeParameters(this.daoClassInfo, this.indexView, this.typeBundle, this.typeBundle.repositoryBase());
        this.entityType = this.typeArguments.getOrDefault("Entity", KotlinPanacheClassVisitor.OBJECT).type();
        this.panacheRepositoryBaseClassInfo = this.indexView.getClassByName(baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.descriptor() : type;
        };
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : KotlinPanacheClassVisitor.OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1) : KotlinPanacheClassVisitor.OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, KotlinPanacheClassVisitor.OBJECT.descriptor()));
        try {
            ByteCodeType entity = this.typeArguments.get("Entity");
            this.erasures.put(entity.dotName().toString(), this.entityUpperBound.descriptor());
            this.erasures.put(types.queryType().dotName().toString(), KotlinPanacheClassVisitor.OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), KotlinPanacheClassVisitor.OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        return super.visitMethod(access, methodName, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheRepositoryBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, type -> this.typeArguments.getOrDefault(type, KotlinPanacheClassVisitor.OBJECT).descriptor());
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateModelBridge(method);
            if (!this.needsJvmBridge(method)) continue;
            this.generateJvmBridge(method);
        }
        super.visitEnd();
    }

    private boolean needsJvmBridge(MethodInfo method) {
        if (this.needsJvmBridge(method.returnType())) {
            return true;
        }
        for (Type paramType : method.parameters()) {
            if (!this.needsJvmBridge(paramType)) continue;
            return true;
        }
        return false;
    }

    private boolean needsJvmBridge(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            String typeParamName = type.asTypeVariable().identifier();
            return this.typeArguments.containsKey(typeParamName);
        }
        return false;
    }

    protected void generateJvmBridge(MethodInfo method) {
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
        if (!this.userMethods.contains(method.name() + "/" + descriptor)) {
            MethodVisitor mv = super.visitMethod(4161, method.name(), descriptor, null, null);
            List parameters = method.parameters();
            AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            for (int i = 0; i < parameters.size(); ++i) {
                Type paramType = (Type)parameters.get(i);
                if (paramType.kind() == Type.Kind.PRIMITIVE) {
                    throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + method + ": has primitive parameters");
                }
                mv.visitIntInsn(25, i + 1);
                if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
                String typeParamName = paramType.asTypeVariable().identifier();
                org.objectweb.asm.Type type = this.typeArguments.get(typeParamName).type();
                if (type.getSort() > 8) {
                    mv.visitTypeInsn(192, type.getInternalName());
                    continue;
                }
                AsmUtil.unboxIfRequired((MethodVisitor)mv, (org.objectweb.asm.Type)type);
            }
            String targetDescriptor = AsmUtil.getDescriptor((MethodInfo)method, this.argMapper);
            mv.visitMethodInsn(182, this.daoBinaryName, method.name(), targetDescriptor, false);
            String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
            mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void generateModelBridge(MethodInfo method) {
        List parameters = method.parameters();
        MethodVisitor mv = super.visitMethod(1, method.name(), AsmUtil.getDescriptor((MethodInfo)method, this.argMapper), AsmUtil.getSignature((MethodInfo)method, this.argMapper), null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        this.loadOperations(mv);
        this.loadArguments(parameters, mv);
        this.invokeOperations(mv, method);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeOperations(MethodVisitor mv, MethodInfo method) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(CLASS.descriptor());
        this.descriptors(method, joiner);
        Type returnType = method.returnType();
        String descriptor = AsmUtil.getDescriptor((Type)returnType, this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationDescriptor = joiner + this.erasures.getOrDefault(key, descriptor);
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (returnType.kind() != Type.Kind.PRIMITIVE) {
            String cast;
            if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
                ByteCodeType type = this.typeArguments.getOrDefault(returnType.asTypeVariable().identifier(), this.entityUpperBound);
                cast = type.internalName();
            } else {
                cast = returnType.name().toString().replace('.', '/');
            }
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        for (Type parameter : method.parameters()) {
            if (parameter.kind() == Type.Kind.TYPE_VARIABLE || method.name().endsWith("ById") && parameter.name().equals((Object)this.typeArguments.get("Id").dotName())) {
                joiner.add(KotlinPanacheClassVisitor.OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    private String mapType(Type parameter) {
        String descriptor;
        switch (parameter.kind()) {
            case PRIMITIVE: 
            case TYPE_VARIABLE: {
                descriptor = KotlinPanacheClassVisitor.OBJECT.descriptor();
                break;
            }
            default: {
                String value = AsmUtil.getDescriptor((Type)parameter, this.argMapper);
                descriptor = this.erasures.getOrDefault(value, value);
            }
        }
        return descriptor;
    }

    private void loadArguments(List<Type> parameters, MethodVisitor mv) {
        this.injectModel(mv);
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i + 1);
        }
    }

    private void loadOperations(MethodVisitor mv) {
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }
}

