/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.common.deployment.PanacheMovingAnnotationVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class PanacheEntityClassAccessorGenerationVisitor
extends ClassVisitor {
    protected final Type thisClass;
    private final Map<String, ? extends EntityField> fields;
    private final Set<String> userMethods = new HashSet<String>();
    private final ClassInfo entityInfo;

    public PanacheEntityClassAccessorGenerationVisitor(ClassVisitor outputClassVisitor, ClassInfo entityInfo, EntityModel entityModel) {
        super(589824, outputClassVisitor);
        String className = entityInfo.name().toString();
        this.thisClass = Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.fields = entityModel != null ? entityModel.fields : null;
        this.entityInfo = entityInfo;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        EntityField entityField;
        EntityField entityField2 = entityField = this.fields == null ? null : this.fields.get(name);
        if (entityField == null) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        FieldVisitor superVisitor = entityField == null || name.equals("id") ? super.visitField(access, name, descriptor, signature, value) : super.visitField((access | 4) & 0xFFFFFFFC, name, descriptor, signature, value);
        entityField.signature = signature;
        return new FieldVisitor(589824, superVisitor){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (!descriptor.startsWith("Ljavax/xml/bind/annotation/")) {
                    return super.visitAnnotation(descriptor, visible);
                }
                EntityField.EntityFieldAnnotation efAnno = new EntityField.EntityFieldAnnotation(descriptor);
                entityField.annotations.add(efAnno);
                return new PanacheMovingAnnotationVisitor(efAnno);
            }

            public void visitEnd() {
                super.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
                super.visitEnd();
            }
        };
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        return super.visitMethod(access, methodName, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        this.generateAccessors();
        super.visitEnd();
    }

    protected void generateAccessors() {
        if (this.fields == null) {
            return;
        }
        for (EntityField entityField : this.fields.values()) {
            int loadCode;
            String getterName = entityField.getGetterName();
            String getterDescriptor = "()" + entityField.descriptor;
            if (!this.userMethods.contains(getterName + "/" + getterDescriptor)) {
                MethodVisitor mv = super.visitMethod(1, getterName, getterDescriptor, entityField.signature == null ? null : "()" + entityField.signature, null);
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                this.generateAccessorGetField(mv, entityField);
                int returnCode = AsmUtil.getReturnInstruction((String)entityField.descriptor);
                mv.visitInsn(returnCode);
                mv.visitMaxs(0, 0);
                for (EntityField.EntityFieldAnnotation anno : entityField.annotations) {
                    anno.writeToVisitor(mv);
                }
                if (this.shouldAddJsonProperty(entityField)) {
                    AnnotationValue jsonPropertyValue;
                    AnnotationInstance jsonPropertyInstance;
                    AnnotationVisitor visitor = mv.visitAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;", true);
                    FieldInfo fieldInfo = this.entityInfo.field(entityField.name);
                    if (fieldInfo != null && (jsonPropertyInstance = fieldInfo.annotation(PanacheConstants.JSON_PROPERTY_DOT_NAME)) != null && (jsonPropertyValue = jsonPropertyInstance.value()) != null && !jsonPropertyValue.asString().isEmpty()) {
                        visitor.visit("value", (Object)jsonPropertyValue.asString());
                    }
                    visitor.visitEnd();
                }
                mv.visitEnd();
            }
            String setterName = entityField.getSetterName();
            String setterDescriptor = "(" + entityField.descriptor + ")V";
            if (this.userMethods.contains(setterName + "/" + setterDescriptor)) continue;
            MethodVisitor mv = super.visitMethod(1, setterName, setterDescriptor, entityField.signature == null ? null : "(" + entityField.signature + ")V", null);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            switch (entityField.descriptor) {
                case "Z": 
                case "B": 
                case "C": 
                case "S": 
                case "I": {
                    loadCode = 21;
                    break;
                }
                case "J": {
                    loadCode = 22;
                    break;
                }
                case "F": {
                    loadCode = 23;
                    break;
                }
                case "D": {
                    loadCode = 24;
                    break;
                }
                default: {
                    loadCode = 25;
                }
            }
            mv.visitIntInsn(loadCode, 1);
            this.generateAccessorSetField(mv, entityField);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private boolean shouldAddJsonProperty(EntityField entityField) {
        if (this.isAnnotatedWithJsonIgnore(entityField)) {
            return false;
        }
        return !entityField.hasAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;");
    }

    private boolean isAnnotatedWithJsonIgnore(EntityField entityField) {
        FieldInfo field = this.entityInfo.field(entityField.name);
        if (field != null) {
            return field.hasAnnotation(PanacheConstants.JSON_IGNORE_DOT_NAME);
        }
        return false;
    }

    protected abstract void generateAccessorSetField(MethodVisitor var1, EntityField var2);

    protected abstract void generateAccessorGetField(MethodVisitor var1, EntityField var2);
}

