/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.panache.common.impl.GenerateBridge;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class JandexUtil {
    public static final DotName DOTNAME_GENERATE_BRIDGE = DotName.createSimple((String)GenerateBridge.class.getName());

    public static String getSignature(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameters();
        StringBuilder signature = new StringBuilder("");
        for (TypeVariable typeVariable : method.typeParameters()) {
            if (signature.length() == 0) {
                signature.append("<");
            } else {
                signature.append(",");
            }
            signature.append(typeVariable.identifier()).append(":");
            JandexUtil.toSignature(signature, (Type)typeVariable.bounds().get(0), typeArgMapper, false);
        }
        if (signature.length() > 0) {
            signature.append(">");
        }
        signature.append("(");
        for (Type type : parameters) {
            JandexUtil.toSignature(signature, type, typeArgMapper, false);
        }
        signature.append(")");
        JandexUtil.toSignature(signature, method.returnType(), typeArgMapper, false);
        return signature.toString();
    }

    public static String getDescriptor(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameters();
        StringBuilder descriptor = new StringBuilder("(");
        for (Type type : parameters) {
            JandexUtil.toSignature(descriptor, type, typeArgMapper, true);
        }
        descriptor.append(")");
        JandexUtil.toSignature(descriptor, method.returnType(), typeArgMapper, true);
        return descriptor.toString();
    }

    static void toSignature(StringBuilder sb, Type type, Function<String, String> typeArgMapper, boolean erased) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    sb.append("[");
                }
                JandexUtil.toSignature(sb, arrayType.component(), typeArgMapper, erased);
                break;
            }
            case CLASS: {
                sb.append("L");
                sb.append(type.asClassType().name().toString().replace('.', '/'));
                sb.append(";");
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                sb.append("L");
                sb.append(parameterizedType.name().toString().replace('.', '/'));
                if (!erased && !parameterizedType.arguments().isEmpty()) {
                    sb.append("<");
                    List arguments = parameterizedType.arguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Type argType = (Type)arguments.get(i);
                        JandexUtil.toSignature(sb, argType, typeArgMapper, erased);
                    }
                    sb.append(">");
                }
                sb.append(";");
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        sb.append('Z');
                        break;
                    }
                    case BYTE: {
                        sb.append('B');
                        break;
                    }
                    case CHAR: {
                        sb.append('C');
                        break;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break;
                    }
                    case INT: {
                        sb.append('I');
                        break;
                    }
                    case LONG: {
                        sb.append('J');
                        break;
                    }
                    case SHORT: {
                        sb.append('S');
                    }
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = type.asTypeVariable();
                String mappedSignature = typeArgMapper.apply(typeVariable.identifier());
                if (mappedSignature != null) {
                    sb.append(mappedSignature);
                    break;
                }
                if (erased) {
                    JandexUtil.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, erased);
                    break;
                }
                sb.append("T").append(typeVariable.identifier()).append(";");
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                break;
            }
            case VOID: {
                sb.append("V");
                break;
            }
            case WILDCARD_TYPE: {
                if (erased) break;
                sb.append("*");
                break;
            }
        }
    }

    public static int getReturnInstruction(String typeDescriptor) {
        switch (typeDescriptor) {
            case "Z": 
            case "B": 
            case "C": 
            case "S": 
            case "I": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "F": {
                return 174;
            }
            case "D": {
                return 175;
            }
            case "V": {
                return 177;
            }
        }
        return 176;
    }

    public static boolean containsMethod(ClassInfo classInfo, String methodName, String returnType, String ... parameters) {
        List types = Arrays.stream(parameters).map(JandexUtil::toClassType).collect(Collectors.toList());
        for (MethodInfo methodInfo : classInfo.methods()) {
            if (!methodInfo.name().equals(methodName) || !methodInfo.parameters().equals(types)) continue;
            return true;
        }
        return false;
    }

    static Type toClassType(String type) {
        return Type.create((DotName)DotName.createSimple((String)type), (Type.Kind)Type.Kind.CLASS);
    }

    public static boolean containsMethod(ClassInfo classInfo, MethodInfo methodInfo) {
        if (classInfo.methods().contains(methodInfo)) {
            return true;
        }
        for (MethodInfo classMethodInfo : classInfo.methods()) {
            if (!classMethodInfo.name().equals(methodInfo.name()) || !classMethodInfo.parameters().equals(methodInfo.parameters())) continue;
            return true;
        }
        return false;
    }
}

