/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.panache.common.impl.GenerateBridge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.MethodVisitor;

public class JandexUtil {
    public static final DotName DOTNAME_GENERATE_BRIDGE = DotName.createSimple((String)GenerateBridge.class.getName());
    public static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());

    public static String getSignature(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameters();
        StringBuilder signature = new StringBuilder("");
        for (TypeVariable typeVariable : method.typeParameters()) {
            if (signature.length() == 0) {
                signature.append("<");
            } else {
                signature.append(",");
            }
            signature.append(typeVariable.identifier()).append(":");
            JandexUtil.toSignature(signature, (Type)typeVariable.bounds().get(0), typeArgMapper, false);
        }
        if (signature.length() > 0) {
            signature.append(">");
        }
        signature.append("(");
        for (Type type : parameters) {
            JandexUtil.toSignature(signature, type, typeArgMapper, false);
        }
        signature.append(")");
        JandexUtil.toSignature(signature, method.returnType(), typeArgMapper, false);
        return signature.toString();
    }

    public static String getDescriptor(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameters();
        StringBuilder descriptor = new StringBuilder("(");
        for (Type type : parameters) {
            JandexUtil.toSignature(descriptor, type, typeArgMapper, true);
        }
        descriptor.append(")");
        JandexUtil.toSignature(descriptor, method.returnType(), typeArgMapper, true);
        return descriptor.toString();
    }

    public static String getDescriptor(Type type, Function<String, String> typeArgMapper) {
        StringBuilder sb = new StringBuilder();
        JandexUtil.toSignature(sb, type, typeArgMapper, true);
        return sb.toString();
    }

    static void toSignature(StringBuilder sb, Type type, Function<String, String> typeArgMapper, boolean erased) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    sb.append("[");
                }
                JandexUtil.toSignature(sb, arrayType.component(), typeArgMapper, erased);
                break;
            }
            case CLASS: {
                sb.append("L");
                sb.append(type.asClassType().name().toString().replace('.', '/'));
                sb.append(";");
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                sb.append("L");
                sb.append(parameterizedType.name().toString().replace('.', '/'));
                if (!erased && !parameterizedType.arguments().isEmpty()) {
                    sb.append("<");
                    List arguments = parameterizedType.arguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Type argType = (Type)arguments.get(i);
                        JandexUtil.toSignature(sb, argType, typeArgMapper, erased);
                    }
                    sb.append(">");
                }
                sb.append(";");
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        sb.append('Z');
                        break;
                    }
                    case BYTE: {
                        sb.append('B');
                        break;
                    }
                    case CHAR: {
                        sb.append('C');
                        break;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break;
                    }
                    case INT: {
                        sb.append('I');
                        break;
                    }
                    case LONG: {
                        sb.append('J');
                        break;
                    }
                    case SHORT: {
                        sb.append('S');
                    }
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = type.asTypeVariable();
                String mappedSignature = typeArgMapper.apply(typeVariable.identifier());
                if (mappedSignature != null) {
                    sb.append(mappedSignature);
                    break;
                }
                if (erased) {
                    JandexUtil.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, erased);
                    break;
                }
                sb.append("T").append(typeVariable.identifier()).append(";");
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                break;
            }
            case VOID: {
                sb.append("V");
                break;
            }
            case WILDCARD_TYPE: {
                if (erased) break;
                sb.append("*");
                break;
            }
        }
    }

    public static int getReturnInstruction(String typeDescriptor) {
        switch (typeDescriptor) {
            case "Z": 
            case "B": 
            case "C": 
            case "S": 
            case "I": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "F": {
                return 174;
            }
            case "D": {
                return 175;
            }
            case "V": {
                return 177;
            }
        }
        return 176;
    }

    public static int getReturnInstruction(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case INT: 
                case SHORT: {
                    return 172;
                }
                case DOUBLE: {
                    return 175;
                }
                case FLOAT: {
                    return 174;
                }
                case LONG: {
                    return 173;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
        }
        if (jandexType.kind() == Type.Kind.VOID) {
            return 177;
        }
        return 176;
    }

    public static void visitLdc(MethodVisitor mv, Type jandexType) {
        block0 : switch (jandexType.kind()) {
            case ARRAY: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)jandexType.name().toString('/').replace('.', '/')));
                break;
            }
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)("L" + jandexType.name().toString('/') + ";")));
                break;
            }
            case PRIMITIVE: {
                switch (jandexType.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case BYTE: {
                        mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case CHAR: {
                        mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case DOUBLE: {
                        mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case FLOAT: {
                        mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case INT: {
                        mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case LONG: {
                        mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                    case SHORT: {
                        mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
            }
            case TYPE_VARIABLE: {
                List bounds = jandexType.asTypeVariable().bounds();
                if (bounds.isEmpty()) {
                    mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                    break;
                }
                JandexUtil.visitLdc(mv, (Type)bounds.get(0));
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(Object.class));
                break;
            }
            case VOID: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case WILDCARD_TYPE: {
                JandexUtil.visitLdc(mv, jandexType.asWildcardType().extendsBound());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown jandex type: " + jandexType);
            }
        }
    }

    public static void boxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case BYTE: {
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case CHAR: {
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case DOUBLE: {
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                case FLOAT: {
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case INT: {
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case LONG: {
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case SHORT: {
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    public static int getLoadOpcode(Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case INT: 
                case SHORT: {
                    return 21;
                }
                case DOUBLE: {
                    return 24;
                }
                case FLOAT: {
                    return 23;
                }
                case LONG: {
                    return 22;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
        }
        return 25;
    }

    public static ClassInfo getEnclosingClass(AnnotationInstance annotationInstance) {
        switch (annotationInstance.target().kind()) {
            case FIELD: {
                return annotationInstance.target().asField().declaringClass();
            }
            case METHOD: {
                return annotationInstance.target().asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                return annotationInstance.target().asMethodParameter().method().declaringClass();
            }
            case CLASS: {
                return annotationInstance.target().asClass();
            }
            case TYPE: {
                return annotationInstance.target().asType().asClass();
            }
        }
        throw new RuntimeException();
    }

    public static boolean isSubclassOf(IndexView index, ClassInfo info, DotName parentName) throws BuildException {
        if (info.superName().equals((Object)DOTNAME_OBJECT)) {
            return false;
        }
        if (info.superName().equals((Object)parentName)) {
            return true;
        }
        Type superType = info.superClassType();
        ClassInfo superClass = index.getClassByName(superType.name());
        if (superClass == null) {
            throw new BuildException("The class " + superType.name() + " is not inside the Jandex index", Collections.emptyList());
        }
        return JandexUtil.isSubclassOf(index, superClass, parentName);
    }

    public static void unboxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    JandexUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case BYTE: {
                    JandexUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case CHAR: {
                    JandexUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case DOUBLE: {
                    JandexUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case FLOAT: {
                    JandexUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case INT: {
                    JandexUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case LONG: {
                    JandexUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case SHORT: {
                    JandexUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
        mv.visitTypeInsn(192, owner);
        mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
    }

    public static Type[] getParameterTypes(String methodDescriptor) {
        String argsSignature = methodDescriptor.substring(methodDescriptor.indexOf(40) + 1, methodDescriptor.lastIndexOf(41));
        ArrayList<Type> args = new ArrayList<Type>();
        char[] chars = argsSignature.toCharArray();
        int dimensions = 0;
        int start = 0;
        block12: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case 'Z': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"boolean"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'B': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"byte"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'C': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"char"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'D': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"double"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'F': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"float"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'I': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"int"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'J': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"long"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'S': {
                    args.add(Type.create((DotName)DotName.createSimple((String)"short"), (Type.Kind)(dimensions > 0 ? Type.Kind.ARRAY : Type.Kind.PRIMITIVE)));
                    dimensions = 0;
                    start = i + 1;
                    continue block12;
                }
                case 'L': {
                    int end = argsSignature.indexOf(59, i);
                    String binaryName = argsSignature.substring(i + 1, end);
                    if (dimensions > 0) {
                        args.add(Type.create((DotName)DotName.createSimple((String)argsSignature.substring(start, end + 1)), (Type.Kind)Type.Kind.ARRAY));
                        dimensions = 0;
                    } else {
                        args.add(Type.create((DotName)DotName.createSimple((String)binaryName.replace('/', '.')), (Type.Kind)Type.Kind.CLASS));
                    }
                    i = end;
                    start = i + 1;
                    continue block12;
                }
                case '[': {
                    ++dimensions;
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("Invalid signature char: " + c);
                }
            }
        }
        return args.toArray(new Type[0]);
    }

    public static int getParameterSize(Type paramType) {
        if (paramType.kind() == Type.Kind.PRIMITIVE) {
            switch (paramType.asPrimitiveType().primitive()) {
                case DOUBLE: 
                case LONG: {
                    return 2;
                }
            }
        }
        return 1;
    }
}

