/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.JandexUtil;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheFieldAccessMethodVisitor;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerVisitor;
import io.quarkus.panache.common.deployment.PanacheMovingAnnotationVisitor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheEntityEnhancer<MetamodelType extends MetamodelInfo<?>>
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    public static final String SORT_NAME = Sort.class.getName();
    public static final String SORT_BINARY_NAME = SORT_NAME.replace('.', '/');
    public static final String SORT_SIGNATURE = "L" + SORT_BINARY_NAME + ";";
    public static final String PARAMETERS_NAME = Parameters.class.getName();
    public static final String PARAMETERS_BINARY_NAME = PARAMETERS_NAME.replace('.', '/');
    public static final String PARAMETERS_SIGNATURE = "L" + PARAMETERS_BINARY_NAME + ";";
    private static final String JAXB_ANNOTATION_PREFIX = "Ljavax/xml/bind/annotation/";
    private static final String JAXB_TRANSIENT_BINARY_NAME = "javax/xml/bind/annotation/XmlTransient";
    private static final String JAXB_TRANSIENT_SIGNATURE = "Ljavax/xml/bind/annotation/XmlTransient;";
    private static final String JSON_PROPERTY_BINARY_NAME = "com/fasterxml/jackson/annotation/JsonProperty";
    private static final String JSON_PROPERTY_SIGNATURE = "Lcom/fasterxml/jackson/annotation/JsonProperty;";
    protected MetamodelType modelInfo;
    protected final ClassInfo panacheEntityBaseClassInfo;
    protected final IndexView indexView;
    protected final List<PanacheMethodCustomizer> methodCustomizers;

    public PanacheEntityEnhancer(IndexView index, DotName panacheEntityBaseName, List<PanacheMethodCustomizer> methodCustomizers) {
        this.panacheEntityBaseClassInfo = index.getClassByName(panacheEntityBaseName);
        this.indexView = index;
        this.methodCustomizers = methodCustomizers;
    }

    @Override
    public abstract ClassVisitor apply(String var1, ClassVisitor var2);

    public abstract void collectFields(ClassInfo var1);

    public MetamodelType getModelInfo() {
        return this.modelInfo;
    }

    public static abstract class PanacheEntityClassVisitor<EntityFieldType extends EntityField>
    extends ClassVisitor {
        protected org.objectweb.asm.Type thisClass;
        protected Map<String, ? extends EntityFieldType> fields;
        private Set<String> userMethods = new HashSet<String>();
        private MetamodelInfo<?> modelInfo;
        private ClassInfo panacheEntityBaseClassInfo;
        protected ClassInfo entityInfo;
        protected List<PanacheMethodCustomizer> methodCustomizers;

        public PanacheEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<? extends EntityModel<? extends EntityFieldType>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
            super(524288, outputClassVisitor);
            this.thisClass = org.objectweb.asm.Type.getType((String)("L" + className.replace('.', '/') + ";"));
            this.modelInfo = modelInfo;
            EntityModel<? extends EntityFieldType> entityModel = modelInfo.getEntityModel(className);
            this.fields = entityModel != null ? entityModel.fields : null;
            this.panacheEntityBaseClassInfo = panacheEntityBaseClassInfo;
            this.entityInfo = entityInfo;
            this.methodCustomizers = methodCustomizers;
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            FieldVisitor superVisitor = super.visitField(access, name, descriptor, signature, value);
            final EntityField ef = (EntityField)this.fields.get(name);
            if (ef == null) {
                return superVisitor;
            }
            ef.signature = signature;
            return new FieldVisitor(524288, superVisitor){
                private Set<String> descriptors;
                {
                    super(x0, x1);
                    this.descriptors = new HashSet<String>();
                }

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    this.descriptors.add(descriptor);
                    if (!descriptor.startsWith(PanacheEntityEnhancer.JAXB_ANNOTATION_PREFIX)) {
                        return super.visitAnnotation(descriptor, visible);
                    }
                    EntityField.EntityFieldAnnotation efAnno = new EntityField.EntityFieldAnnotation(descriptor);
                    ef.annotations.add(efAnno);
                    return new PanacheMovingAnnotationVisitor(efAnno);
                }

                public void visitEnd() {
                    super.visitAnnotation(PanacheEntityEnhancer.JAXB_TRANSIENT_SIGNATURE, true);
                    super.visitEnd();
                }
            };
        }

        public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
            this.userMethods.add(methodName + "/" + descriptor);
            MethodVisitor superVisitor = super.visitMethod(access, methodName, descriptor, signature, exceptions);
            if (Modifier.isStatic(access) && Modifier.isPublic(access) && (access & 0x1000) == 0 && !this.methodCustomizers.isEmpty()) {
                Object[] argTypes = JandexUtil.getParameterTypes(descriptor);
                MethodInfo method = this.entityInfo.method(methodName, (Type[])argTypes);
                if (method == null) {
                    throw new IllegalStateException("Could not find indexed method: " + this.thisClass + "." + methodName + " with descriptor " + descriptor + " and arg types " + Arrays.toString(argTypes));
                }
                superVisitor = new PanacheMethodCustomizerVisitor(superVisitor, method, this.thisClass, this.methodCustomizers);
            }
            return new PanacheFieldAccessMethodVisitor(superVisitor, this.thisClass.getInternalName(), methodName, descriptor, this.modelInfo);
        }

        public void visitEnd() {
            for (MethodInfo method : this.panacheEntityBaseClassInfo.methods()) {
                AnnotationInstance bridge;
                String descriptor = JandexUtil.getDescriptor(method, name -> null);
                if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(JandexUtil.DOTNAME_GENERATE_BRIDGE)) == null) continue;
                this.generateMethod(method, bridge.value("targetReturnTypeErased"));
            }
            this.generateAccessors();
            super.visitEnd();
        }

        private void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased) {
            String descriptor = JandexUtil.getDescriptor(method, name -> null);
            String signature = JandexUtil.getSignature(method, name -> null);
            List parameters = method.parameters();
            String castTo = null;
            if (targetReturnTypeErased != null && targetReturnTypeErased.asBoolean()) {
                castTo = method.returnType().name().toString('/');
            }
            MethodVisitor mv = super.visitMethod(4105, method.name(), descriptor, signature, null);
            for (int i = 0; i < parameters.size(); ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
            mv.visitCode();
            for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
                customizer.customize(this.thisClass, method, mv);
            }
            this.injectModel(mv);
            for (int i = 0; i < parameters.size(); ++i) {
                mv.visitIntInsn(25, i);
            }
            String forwardingDescriptor = "(" + this.getModelDescriptor() + descriptor.substring(1);
            if (castTo != null) {
                int lastParen = forwardingDescriptor.lastIndexOf(41);
                forwardingDescriptor = forwardingDescriptor.substring(0, lastParen + 1) + "Ljava/lang/Object;";
            }
            mv.visitMethodInsn(184, this.getPanacheOperationsBinaryName(), method.name(), forwardingDescriptor, false);
            if (castTo != null) {
                mv.visitTypeInsn(192, castTo);
            }
            String returnTypeDescriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
            mv.visitInsn(JandexUtil.getReturnInstruction(returnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        protected abstract String getModelDescriptor();

        protected abstract String getPanacheOperationsBinaryName();

        protected abstract void injectModel(MethodVisitor var1);

        protected void generateAccessors() {
            if (this.fields == null) {
                return;
            }
            for (EntityField field : this.fields.values()) {
                int loadCode;
                String getterName = field.getGetterName();
                String getterDescriptor = "()" + field.descriptor;
                if (!this.userMethods.contains(getterName + "/" + getterDescriptor)) {
                    MethodVisitor mv = super.visitMethod(1, getterName, getterDescriptor, field.signature == null ? null : "()" + field.signature, null);
                    mv.visitCode();
                    mv.visitIntInsn(25, 0);
                    this.generateAccessorGetField(mv, field);
                    int returnCode = JandexUtil.getReturnInstruction(field.descriptor);
                    mv.visitInsn(returnCode);
                    mv.visitMaxs(0, 0);
                    for (EntityField.EntityFieldAnnotation anno : field.annotations) {
                        anno.writeToVisitor(mv);
                    }
                    if (!field.hasAnnotation(PanacheEntityEnhancer.JSON_PROPERTY_SIGNATURE)) {
                        mv.visitAnnotation(PanacheEntityEnhancer.JSON_PROPERTY_SIGNATURE, true);
                    }
                    mv.visitEnd();
                }
                String setterName = field.getSetterName();
                String setterDescriptor = "(" + field.descriptor + ")V";
                if (this.userMethods.contains(setterName + "/" + setterDescriptor)) continue;
                MethodVisitor mv = super.visitMethod(1, setterName, setterDescriptor, field.signature == null ? null : "(" + field.signature + ")V", null);
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                switch (field.descriptor) {
                    case "Z": 
                    case "B": 
                    case "C": 
                    case "S": 
                    case "I": {
                        loadCode = 21;
                        break;
                    }
                    case "J": {
                        loadCode = 22;
                        break;
                    }
                    case "F": {
                        loadCode = 23;
                        break;
                    }
                    case "D": {
                        loadCode = 24;
                        break;
                    }
                    default: {
                        loadCode = 25;
                    }
                }
                mv.visitIntInsn(loadCode, 1);
                this.generateAccessorSetField(mv, field);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }

        protected abstract void generateAccessorSetField(MethodVisitor var1, EntityField var2);

        protected abstract void generateAccessorGetField(MethodVisitor var1, EntityField var2);
    }
}

