/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.panache.common.deployment.JandexUtil;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheRepositoryEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final DotName OBJECT_DOT_NAME = DotName.createSimple((String)Object.class.getName());
    protected final ClassInfo panacheRepositoryBaseClassInfo;
    protected final IndexView indexView;

    public PanacheRepositoryEnhancer(IndexView index, DotName panacheRepositoryBaseName) {
        this.panacheRepositoryBaseClassInfo = index.getClassByName(panacheRepositoryBaseName);
        this.indexView = index;
    }

    @Override
    public abstract ClassVisitor apply(String var1, ClassVisitor var2);

    public static boolean skipRepository(ClassInfo classInfo) {
        return Modifier.isAbstract(classInfo.flags()) || !classInfo.typeParameters().isEmpty();
    }

    public static abstract class PanacheRepositoryClassVisitor
    extends ClassVisitor {
        protected org.objectweb.asm.Type entityType;
        protected String entitySignature;
        protected String entityBinaryType;
        protected String idSignature;
        protected String idBinaryType;
        protected String daoBinaryName;
        protected ClassInfo daoClassInfo;
        protected ClassInfo panacheRepositoryBaseClassInfo;
        protected IndexView indexView;
        protected Map<String, String> typeArguments = new HashMap<String, String>();
        protected Set<String> userMethods = new HashSet<String>();

        public PanacheRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, ClassInfo panacheRepositoryBaseClassInfo, IndexView indexView) {
            super(524288, outputClassVisitor);
            this.daoClassInfo = indexView.getClassByName(DotName.createSimple((String)className));
            this.daoBinaryName = className.replace('.', '/');
            this.panacheRepositoryBaseClassInfo = panacheRepositoryBaseClassInfo;
            this.indexView = indexView;
        }

        protected abstract DotName getPanacheRepositoryDotName();

        protected abstract DotName getPanacheRepositoryBaseDotName();

        protected abstract String getPanacheOperationsBinaryName();

        protected abstract String getModelDescriptor();

        protected abstract void injectModel(MethodVisitor var1);

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String repositoryClassName = name.replace('/', '.');
            String[] foundTypeArguments = PanacheRepositoryClassVisitor.findEntityTypeArgumentsForPanacheRepository(this.indexView, repositoryClassName, this.getPanacheRepositoryBaseDotName());
            this.entityBinaryType = foundTypeArguments[0];
            this.entitySignature = "L" + this.entityBinaryType + ";";
            this.entityType = org.objectweb.asm.Type.getType((String)this.entitySignature);
            this.idBinaryType = foundTypeArguments[1];
            this.idSignature = "L" + this.idBinaryType + ";";
            this.typeArguments.put("Entity", this.entitySignature);
            this.typeArguments.put("Id", this.idSignature);
        }

        public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
            this.userMethods.add(methodName + "/" + descriptor);
            return super.visitMethod(access, methodName, descriptor, signature, exceptions);
        }

        public static String[] findEntityTypeArgumentsForPanacheRepository(IndexView indexView, String repositoryClassName, DotName repositoryDotName) {
            for (ClassInfo classInfo : indexView.getAllKnownImplementors(repositoryDotName)) {
                if (!repositoryClassName.equals(classInfo.name().toString())) continue;
                return PanacheRepositoryClassVisitor.recursivelyFindEntityTypeArgumentsFromClass(indexView, classInfo.name(), repositoryDotName);
            }
            return null;
        }

        public static String[] recursivelyFindEntityTypeArgumentsFromClass(IndexView indexView, DotName clazz, DotName repositoryDotName) {
            if (clazz.equals((Object)OBJECT_DOT_NAME)) {
                return null;
            }
            List typeParameters = io.quarkus.deployment.util.JandexUtil.resolveTypeParameters((DotName)clazz, (DotName)repositoryDotName, (IndexView)indexView);
            if (typeParameters.isEmpty()) {
                throw new IllegalStateException("Failed to find supertype " + repositoryDotName + " from entity class " + clazz);
            }
            Type entityType = (Type)typeParameters.get(0);
            Type idType = (Type)typeParameters.get(1);
            return new String[]{entityType.name().toString().replace('.', '/'), idType.name().toString().replace('.', '/')};
        }

        public void visitEnd() {
            for (MethodInfo method : this.panacheRepositoryBaseClassInfo.methods()) {
                AnnotationInstance bridge;
                String descriptor = JandexUtil.getDescriptor(method, name -> this.typeArguments.get(name));
                if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(JandexUtil.DOTNAME_GENERATE_BRIDGE)) == null) continue;
                this.generateModelBridge(method, bridge.value("targetReturnTypeErased"));
                if (!this.needsJvmBridge(method)) continue;
                this.generateJvmBridge(method);
            }
            super.visitEnd();
        }

        private boolean needsJvmBridge(MethodInfo method) {
            if (this.needsJvmBridge(method.returnType())) {
                return true;
            }
            for (Type paramType : method.parameters()) {
                if (!this.needsJvmBridge(paramType)) continue;
                return true;
            }
            return false;
        }

        private boolean needsJvmBridge(Type type) {
            if (type.kind() == Type.Kind.TYPE_VARIABLE) {
                String typeParamName = type.asTypeVariable().identifier();
                return this.typeArguments.containsKey(typeParamName);
            }
            return false;
        }

        private void generateJvmBridge(MethodInfo method) {
            String descriptor = JandexUtil.getDescriptor(method, name -> null);
            if (!this.userMethods.contains(method.name() + "/" + descriptor)) {
                int i;
                MethodVisitor mv = super.visitMethod(4161, method.name(), descriptor, null, null);
                List parameters = method.parameters();
                for (i = 0; i < parameters.size(); ++i) {
                    mv.visitParameter(method.parameterName(i), 0);
                }
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                block9: for (i = 0; i < parameters.size(); ++i) {
                    String typeParamName;
                    Type paramType = (Type)parameters.get(i);
                    if (paramType.kind() == Type.Kind.PRIMITIVE) {
                        throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + method + ": has primitive parameters");
                    }
                    mv.visitIntInsn(25, i + 1);
                    if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
                    switch (typeParamName = paramType.asTypeVariable().identifier()) {
                        case "Entity": {
                            mv.visitTypeInsn(192, this.entityBinaryType);
                            continue block9;
                        }
                        case "Id": {
                            mv.visitTypeInsn(192, this.idBinaryType);
                        }
                    }
                }
                String targetDescriptor = JandexUtil.getDescriptor(method, name -> this.typeArguments.get(name));
                mv.visitMethodInsn(182, this.daoBinaryName, method.name(), targetDescriptor, false);
                String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
                mv.visitInsn(JandexUtil.getReturnInstruction(targetReturnTypeDescriptor));
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }

        private void generateModelBridge(MethodInfo method, AnnotationValue targetReturnTypeErased) {
            int i;
            String descriptor = JandexUtil.getDescriptor(method, name -> this.typeArguments.get(name));
            String descriptorForJpaOperations = JandexUtil.getDescriptor(method, name -> name.equals("Entity") ? this.entitySignature : null);
            String signature = JandexUtil.getSignature(method, name -> this.typeArguments.get(name));
            List parameters = method.parameters();
            String castTo = null;
            if (targetReturnTypeErased != null && targetReturnTypeErased.asBoolean()) {
                Type type = method.returnType();
                if (type.kind() == Type.Kind.TYPE_VARIABLE && type.asTypeVariable().identifier().equals("Entity")) {
                    castTo = this.entityBinaryType;
                }
                if (castTo == null) {
                    castTo = type.name().toString('/');
                }
            }
            MethodVisitor mv = super.visitMethod(1, method.name(), descriptor, signature, null);
            for (i = 0; i < parameters.size(); ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
            mv.visitCode();
            this.injectModel(mv);
            for (i = 0; i < parameters.size(); ++i) {
                mv.visitIntInsn(25, i + 1);
            }
            String forwardingDescriptor = "(" + this.getModelDescriptor() + descriptorForJpaOperations.substring(1);
            if (castTo != null) {
                int lastParen = forwardingDescriptor.lastIndexOf(41);
                forwardingDescriptor = forwardingDescriptor.substring(0, lastParen + 1) + "Ljava/lang/Object;";
            }
            mv.visitMethodInsn(184, this.getPanacheOperationsBinaryName(), method.name(), forwardingDescriptor, false);
            if (castTo != null) {
                mv.visitTypeInsn(192, castTo);
            }
            String returnTypeDescriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
            mv.visitInsn(JandexUtil.getReturnInstruction(returnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }
}

