/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheRepositoryClassVisitor
extends ClassVisitor {
    protected org.objectweb.asm.Type entityType;
    protected String entitySignature;
    protected String entityBinaryType;
    protected String idSignature;
    protected String idBinaryType;
    protected String daoBinaryName;
    protected ClassInfo daoClassInfo;
    protected ClassInfo panacheRepositoryBaseClassInfo;
    protected IndexView indexView;
    protected Map<String, String> typeArguments = new HashMap<String, String>();
    protected Set<String> userMethods = new HashSet<String>();

    public PanacheRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, IndexView indexView) {
        super(524288, outputClassVisitor);
        this.daoClassInfo = indexView.getClassByName(DotName.createSimple((String)className));
        this.daoBinaryName = className.replace('.', '/');
        this.indexView = indexView;
    }

    protected abstract DotName getPanacheRepositoryDotName();

    protected abstract DotName getPanacheRepositoryBaseDotName();

    protected abstract String getPanacheOperationsInternalName();

    protected String getModelDescriptor() {
        return "Ljava/lang/Class;";
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.entityType);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String repositoryClassName = name.replace('/', '.');
        String[] foundTypeArguments = PanacheRepositoryClassVisitor.findEntityTypeArgumentsForPanacheRepository(this.indexView, repositoryClassName, this.getPanacheRepositoryBaseDotName());
        this.entityBinaryType = foundTypeArguments[0];
        this.entitySignature = "L" + this.entityBinaryType + ";";
        this.entityType = org.objectweb.asm.Type.getType((String)this.entitySignature);
        this.idBinaryType = foundTypeArguments[1];
        this.idSignature = "L" + this.idBinaryType + ";";
        org.objectweb.asm.Type idType = org.objectweb.asm.Type.getType((String)this.idSignature);
        this.typeArguments.put("Entity", this.entityType.getDescriptor());
        this.typeArguments.put("Id", idType.getDescriptor());
        this.panacheRepositoryBaseClassInfo = this.indexView.getClassByName(this.getPanacheRepositoryBaseDotName());
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        return super.visitMethod(access, methodName, descriptor, signature, exceptions);
    }

    public static String[] findEntityTypeArgumentsForPanacheRepository(IndexView indexView, String repositoryClassName, DotName repositoryDotName) {
        for (ClassInfo classInfo : indexView.getAllKnownImplementors(repositoryDotName)) {
            if (!repositoryClassName.equals(classInfo.name().toString())) continue;
            return PanacheRepositoryClassVisitor.recursivelyFindEntityTypeArgumentsFromClass(indexView, classInfo.name(), repositoryDotName);
        }
        return null;
    }

    public static String[] recursivelyFindEntityTypeArgumentsFromClass(IndexView indexView, DotName clazz, DotName repositoryDotName) {
        if (clazz.equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            return null;
        }
        List typeParameters = JandexUtil.resolveTypeParameters((DotName)clazz, (DotName)repositoryDotName, (IndexView)indexView);
        if (typeParameters.isEmpty()) {
            throw new IllegalStateException("Failed to find supertype " + repositoryDotName + " from entity class " + clazz);
        }
        Type entityType = (Type)typeParameters.get(0);
        Type idType = (Type)typeParameters.get(1);
        return new String[]{entityType.name().toString().replace('.', '/'), idType.name().toString().replace('.', '/')};
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheRepositoryBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> this.typeArguments.get(name));
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateModelBridge(method, bridge.value("targetReturnTypeErased"));
            if (!this.needsJvmBridge(method)) continue;
            this.generateJvmBridge(method);
        }
        super.visitEnd();
    }

    private boolean needsJvmBridge(MethodInfo method) {
        if (this.needsJvmBridge(method.returnType())) {
            return true;
        }
        for (Type paramType : method.parameters()) {
            if (!this.needsJvmBridge(paramType)) continue;
            return true;
        }
        return false;
    }

    private boolean needsJvmBridge(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            String typeParamName = type.asTypeVariable().identifier();
            return this.typeArguments.containsKey(typeParamName);
        }
        return false;
    }

    protected void generateJvmBridge(MethodInfo method) {
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
        if (!this.userMethods.contains(method.name() + "/" + descriptor)) {
            int i;
            MethodVisitor mv = super.visitMethod(4161, method.name(), descriptor, null, null);
            List parameters = method.parameters();
            for (i = 0; i < parameters.size(); ++i) {
                mv.visitParameter(method.parameterName(i), 0);
            }
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            for (i = 0; i < parameters.size(); ++i) {
                Type paramType = (Type)parameters.get(i);
                if (paramType.kind() == Type.Kind.PRIMITIVE) {
                    throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + method + ": has primitive parameters");
                }
                mv.visitIntInsn(25, i + 1);
                if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
                String typeParamName = paramType.asTypeVariable().identifier();
                org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)this.typeArguments.get(typeParamName));
                if (type.getSort() > 8) {
                    mv.visitTypeInsn(192, type.getInternalName());
                    continue;
                }
                AsmUtil.unboxIfRequired((MethodVisitor)mv, (org.objectweb.asm.Type)type);
            }
            String targetDescriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> this.typeArguments.get(name));
            mv.visitMethodInsn(182, this.daoBinaryName, method.name(), targetDescriptor, false);
            String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
            mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void generateModelBridge(MethodInfo method, AnnotationValue targetReturnTypeErased) {
        int i;
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> this.typeArguments.get(name));
        String descriptorForJpaOperations = AsmUtil.getDescriptor((MethodInfo)method, name -> name.equals("Entity") ? this.entitySignature : null);
        String signature = AsmUtil.getSignature((MethodInfo)method, name -> this.typeArguments.get(name));
        List parameters = method.parameters();
        String castTo = null;
        if (targetReturnTypeErased != null && targetReturnTypeErased.asBoolean()) {
            Type type = method.returnType();
            if (type.kind() == Type.Kind.TYPE_VARIABLE && type.asTypeVariable().identifier().equals("Entity")) {
                castTo = this.entityBinaryType;
            }
            if (castTo == null) {
                castTo = type.name().toString('/');
            }
        }
        MethodVisitor mv = super.visitMethod(1, method.name(), descriptor, signature, null);
        for (i = 0; i < parameters.size(); ++i) {
            mv.visitParameter(method.parameterName(i), 0);
        }
        mv.visitCode();
        this.injectModel(mv);
        for (i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i + 1);
        }
        String forwardingDescriptor = "(" + this.getModelDescriptor() + descriptorForJpaOperations.substring(1);
        if (castTo != null) {
            int lastParen = forwardingDescriptor.lastIndexOf(41);
            forwardingDescriptor = forwardingDescriptor.substring(0, lastParen + 1) + "Ljava/lang/Object;";
        }
        mv.visitMethodInsn(184, this.getPanacheOperationsInternalName(), method.name(), forwardingDescriptor, false);
        if (castTo != null) {
            mv.visitTypeInsn(192, castTo);
        }
        String returnTypeDescriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        mv.visitInsn(AsmUtil.getReturnInstruction((String)returnTypeDescriptor));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

