/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.common.deployment.PanacheMovingAnnotationVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class PanacheEntityClassAccessorGenerationVisitor
extends ClassVisitor {
    protected final Type thisClass;
    private final Map<String, ? extends EntityField> fields;
    private final Set<String> userMethods = new HashSet<String>();
    private final ClassInfo entityInfo;

    public PanacheEntityClassAccessorGenerationVisitor(ClassVisitor outputClassVisitor, ClassInfo entityInfo, EntityModel entityModel) {
        super(589824, outputClassVisitor);
        String className = entityInfo.name().toString();
        this.thisClass = Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.fields = entityModel != null ? entityModel.fields : null;
        this.entityInfo = entityInfo;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        EntityField entityField;
        EntityField entityField2 = entityField = this.fields == null ? null : this.fields.get(name);
        if (entityField == null) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        FieldVisitor superVisitor = name.equals("id") ? super.visitField(access, name, descriptor, signature, value) : super.visitField((access | 4) & 0xFFFFFFFC, name, descriptor, signature, value);
        entityField.signature = signature;
        return new FieldVisitor(589824, superVisitor){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (!descriptor.startsWith("Ljakarta/xml/bind/annotation/")) {
                    return super.visitAnnotation(descriptor, visible);
                }
                EntityField.EntityFieldAnnotation efAnno = new EntityField.EntityFieldAnnotation(descriptor);
                entityField.annotations.add(efAnno);
                return new PanacheMovingAnnotationVisitor(efAnno);
            }

            public void visitEnd() {
                super.visitAnnotation("Ljakarta/xml/bind/annotation/XmlTransient;", true);
                super.visitEnd();
            }
        };
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        return super.visitMethod(access, methodName, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        this.generateAccessors();
        super.visitEnd();
    }

    private void generateAccessors() {
        if (this.fields == null) {
            return;
        }
        for (EntityField entityField : this.fields.values()) {
            int loadCode;
            String setterDescriptor;
            String setterName;
            String getterDescriptor;
            String getterName = entityField.getGetterName();
            if (!this.userMethods.contains(getterName + "/" + (getterDescriptor = "()" + entityField.descriptor))) {
                MethodVisitor mv = super.visitMethod(1, getterName, getterDescriptor, entityField.signature == null ? null : "()" + entityField.signature, null);
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                mv.visitFieldInsn(180, this.thisClass.getInternalName(), entityField.name, entityField.descriptor);
                int returnCode = AsmUtil.getReturnInstruction((String)entityField.descriptor);
                mv.visitInsn(returnCode);
                mv.visitMaxs(0, 0);
                for (EntityField.EntityFieldAnnotation anno : entityField.annotations) {
                    anno.writeToVisitor(mv);
                }
                if (this.shouldAddJsonProperty(entityField)) {
                    AnnotationInstance jsonPropertyInstance;
                    AnnotationVisitor visitor = mv.visitAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;", true);
                    FieldInfo fieldInfo = this.entityInfo.field(entityField.name);
                    if (fieldInfo != null && (jsonPropertyInstance = fieldInfo.annotation(PanacheConstants.JSON_PROPERTY_DOT_NAME)) != null) {
                        this.propagateJsonPropertyValues(jsonPropertyInstance, visitor);
                    }
                    visitor.visitEnd();
                }
                mv.visitEnd();
            }
            if (this.userMethods.contains((setterName = entityField.getSetterName()) + "/" + (setterDescriptor = "(" + entityField.descriptor + ")V"))) continue;
            MethodVisitor mv = super.visitMethod(1, setterName, setterDescriptor, entityField.signature == null ? null : "(" + entityField.signature + ")V", null);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            switch (entityField.descriptor) {
                case "Z": 
                case "B": 
                case "C": 
                case "S": 
                case "I": {
                    loadCode = 21;
                    break;
                }
                case "J": {
                    loadCode = 22;
                    break;
                }
                case "F": {
                    loadCode = 23;
                    break;
                }
                case "D": {
                    loadCode = 24;
                    break;
                }
                default: {
                    loadCode = 25;
                }
            }
            mv.visitIntInsn(loadCode, 1);
            mv.visitFieldInsn(181, this.thisClass.getInternalName(), entityField.name, entityField.descriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void propagateJsonPropertyValues(AnnotationInstance from, AnnotationVisitor to) {
        AnnotationValue jsonPropertyAccess;
        AnnotationValue jsonPropertyIndex;
        this.copyAnnotationStringValue(from, to, "value");
        this.copyAnnotationStringValue(from, to, "namespace");
        this.copyAnnotationStringValue(from, to, "defaultValue");
        AnnotationValue jsonPropertyRequired = from.value("required");
        if (jsonPropertyRequired != null) {
            to.visit("required", (Object)jsonPropertyRequired.asBoolean());
        }
        if ((jsonPropertyIndex = from.value("index")) != null) {
            to.visit("index", (Object)jsonPropertyIndex.asInt());
        }
        if ((jsonPropertyAccess = from.value("access")) != null) {
            to.visitEnum("access", "Lcom/fasterxml/jackson/annotation/JsonProperty$Access;", jsonPropertyAccess.asString());
        }
    }

    private void copyAnnotationStringValue(AnnotationInstance from, AnnotationVisitor to, String property) {
        AnnotationValue value = from.value(property);
        if (value != null && !value.asString().isEmpty()) {
            to.visit(property, (Object)value.asString());
        }
    }

    private boolean shouldAddJsonProperty(EntityField entityField) {
        if (this.isAnnotatedWithJsonIgnore(entityField)) {
            return false;
        }
        return !entityField.hasAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;");
    }

    private boolean isAnnotatedWithJsonIgnore(EntityField entityField) {
        FieldInfo field = this.entityInfo.field(entityField.name);
        if (field != null) {
            return field.hasAnnotation(PanacheConstants.JSON_IGNORE_DOT_NAME);
        }
        return false;
    }
}

