/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.panache.common.deployment.HibernateMetamodelForFieldAccessBuildItem;
import io.quarkus.panache.common.deployment.HibernateModelClassCandidatesForFieldAccessBuildItem;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheJpaEntityAccessorsEnhancer;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.persistence.Transient;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;

public final class PanacheHibernateCommonResourceProcessor {
    private static final DotName DOTNAME_TRANSIENT = DotName.createSimple((String)Transient.class.getName());
    private static final DotName DOTNAME_KOTLIN_METADATA = DotName.createSimple((String)"kotlin.Metadata");

    @BuildStep
    void findEntityClasses(CombinedIndexBuildItem index, Optional<HibernateModelClassCandidatesForFieldAccessBuildItem> candidatesForFieldAccess, BuildProducer<HibernateMetamodelForFieldAccessBuildItem> modelInfoBuildItem, BuildProducer<PanacheEntityClassesBuildItem> fieldAccessEnhancedEntityClasses) {
        if (candidatesForFieldAccess.isEmpty()) {
            return;
        }
        MetamodelInfo modelInfo = new MetamodelInfo();
        for (String entityClassName : candidatesForFieldAccess.get().getAllModelClassNames()) {
            ClassInfo entityClass = index.getIndex().getClassByName(DotName.createSimple((String)entityClassName));
            if (entityClass == null || entityClass.annotationsMap().containsKey(DOTNAME_KOTLIN_METADATA)) continue;
            modelInfo.addEntityModel(this.createEntityModel(entityClass));
        }
        modelInfoBuildItem.produce((BuildItem)new HibernateMetamodelForFieldAccessBuildItem(modelInfo));
        Set entitiesWithPublicFields = modelInfo.getEntitiesWithPublicFields();
        if (entitiesWithPublicFields.isEmpty()) {
            return;
        }
        fieldAccessEnhancedEntityClasses.produce((BuildItem)new PanacheEntityClassesBuildItem(entitiesWithPublicFields));
    }

    @BuildStep
    @Consume(value=HibernateEnhancersRegisteredBuildItem.class)
    void replaceFieldAccesses(CombinedIndexBuildItem index, ApplicationArchivesBuildItem applicationArchivesBuildItem, Optional<HibernateMetamodelForFieldAccessBuildItem> modelInfoBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (modelInfoBuildItem.isEmpty()) {
            return;
        }
        MetamodelInfo modelInfo = modelInfoBuildItem.get().getMetamodelInfo();
        Set entitiesWithPublicFields = modelInfo.getEntitiesWithPublicFields();
        if (entitiesWithPublicFields.isEmpty()) {
            return;
        }
        PanacheJpaEntityAccessorsEnhancer entityAccessorsEnhancer = new PanacheJpaEntityAccessorsEnhancer(index.getIndex(), modelInfo);
        for (Object entityClassName : entitiesWithPublicFields) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, (String)entityClassName, (BiFunction)entityAccessorsEnhancer));
        }
        HashSet<String> entityClassNamesInternal = new HashSet<String>();
        for (String entityClassName : entitiesWithPublicFields) {
            entityClassNamesInternal.add(entityClassName.replace(".", "/"));
        }
        PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
        QuarkusClassLoader tccl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        List archives = tccl.getElementsWithResource("META-INF/panache-archive.marker");
        HashSet<String> produced = new HashSet<String>();
        for (ClassInfo i : applicationArchivesBuildItem.getRootArchive().getIndex().getKnownClasses()) {
            String cn = i.name().toString();
            produced.add(cn);
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, entityClassNamesInternal));
        }
        for (ClassInfo i : archives) {
            for (String res : i.getProvidedResources()) {
                String cn;
                if (!res.endsWith(".class") || produced.contains(cn = res.replace("/", ".").substring(0, res.length() - 6))) continue;
                produced.add(cn);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, entityClassNamesInternal));
            }
        }
    }

    private EntityModel createEntityModel(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || Modifier.isStatic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_TRANSIENT)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        return entityModel;
    }
}

