/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.panache.common.deployment.HibernateMetamodelForFieldAccessBuildItem;
import io.quarkus.panache.common.deployment.HibernateModelClassCandidatesForFieldAccessBuildItem;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheJpaEntityAccessorsEnhancer;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;

public final class PanacheHibernateCommonResourceProcessor {
    private static final DotName DOTNAME_ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName DOTNAME_MAPPED_SUPERCLASS = DotName.createSimple((String)MappedSuperclass.class.getName());
    private static final DotName DOTNAME_EMBEDDABLE = DotName.createSimple((String)Embeddable.class.getName());
    private static final DotName DOTNAME_TRANSIENT = DotName.createSimple((String)Transient.class.getName());
    private static final DotName DOTNAME_KOTLIN_METADATA = DotName.createSimple((String)"kotlin.Metadata");

    @BuildStep
    void findEntityClasses(CombinedIndexBuildItem index, Optional<HibernateModelClassCandidatesForFieldAccessBuildItem> candidatesForFieldAccess, BuildProducer<HibernateMetamodelForFieldAccessBuildItem> modelInfoBuildItem, BuildProducer<PanacheEntityClassesBuildItem> fieldAccessEnhancedEntityClasses) {
        if (candidatesForFieldAccess.isEmpty()) {
            return;
        }
        MetamodelInfo modelInfo = new MetamodelInfo();
        for (String entityClassName : candidatesForFieldAccess.get().getManagedClassNames()) {
            ClassInfo entityClass = index.getIndex().getClassByName(DotName.createSimple((String)entityClassName));
            if (entityClass == null || entityClass.annotationsMap().containsKey(DOTNAME_KOTLIN_METADATA)) continue;
            modelInfo.addEntityModel(this.createEntityModel(entityClass));
        }
        modelInfoBuildItem.produce((BuildItem)new HibernateMetamodelForFieldAccessBuildItem(modelInfo));
        Set entitiesWithExternallyAccessibleFields = modelInfo.getEntitiesWithExternallyAccessibleFields();
        if (entitiesWithExternallyAccessibleFields.isEmpty()) {
            return;
        }
        fieldAccessEnhancedEntityClasses.produce((BuildItem)new PanacheEntityClassesBuildItem(entitiesWithExternallyAccessibleFields));
    }

    @BuildStep
    @Consume.List(value={@Consume(value=HibernateEnhancersRegisteredBuildItem.class), @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)})
    void replaceFieldAccesses(CombinedIndexBuildItem index, ApplicationArchivesBuildItem applicationArchivesBuildItem, Optional<HibernateMetamodelForFieldAccessBuildItem> modelInfoBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (modelInfoBuildItem.isEmpty()) {
            return;
        }
        MetamodelInfo modelInfo = modelInfoBuildItem.get().getMetamodelInfo();
        Set entitiesWithExternallyAccessibleFields = modelInfo.getEntitiesWithExternallyAccessibleFields();
        if (entitiesWithExternallyAccessibleFields.isEmpty()) {
            return;
        }
        PanacheJpaEntityAccessorsEnhancer entityAccessorsEnhancer = new PanacheJpaEntityAccessorsEnhancer(index.getIndex(), modelInfo);
        for (Object entityClassName : entitiesWithExternallyAccessibleFields) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, (String)entityClassName, (BiFunction)entityAccessorsEnhancer));
        }
        HashSet<String> entityClassNamesInternal = new HashSet<String>();
        for (String entityClassName : entitiesWithExternallyAccessibleFields) {
            entityClassNamesInternal.add(entityClassName.replace(".", "/"));
        }
        PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
        HashSet<String> produced = new HashSet<String>();
        for (String entityClassName : entitiesWithExternallyAccessibleFields) {
            for (ClassInfo userClass : index.getIndex().getKnownUsers(entityClassName)) {
                String cn = userClass.name().toString('.');
                if (produced.contains(cn)) continue;
                produced.add(cn);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, entityClassNamesInternal));
            }
        }
    }

    private EntityModel createEntityModel(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        boolean isManaged = classInfo.hasAnnotation(DOTNAME_ENTITY) || classInfo.hasAnnotation(DOTNAME_MAPPED_SUPERCLASS) || classInfo.hasAnnotation(DOTNAME_EMBEDDABLE);
        boolean willBeEnhancedByHibernateOrm = isManaged && !classInfo.isRecord();
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String librarySpecificSetterName;
            String librarySpecificGetterName;
            String name = fieldInfo.name();
            if (Modifier.isStatic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_TRANSIENT)) continue;
            if (willBeEnhancedByHibernateOrm) {
                librarySpecificGetterName = "$$_hibernate_read_" + name;
                librarySpecificSetterName = "$$_hibernate_write_" + name;
            } else {
                librarySpecificGetterName = null;
                librarySpecificSetterName = null;
            }
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type()), EntityField.Visibility.get((int)fieldInfo.flags()), librarySpecificGetterName, librarySpecificSetterName));
        }
        return entityModel;
    }
}

