/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.hibernate.common.runtime;

import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PanacheJpaUtil {
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+((?:DISTINCT\\s+)?\\w+(?:\\.\\w+)*)(?:\\s+AS\\s+\\w+)?(\\s*,\\s*\\w+(?:\\.\\w+)*(?:\\s+AS\\s+\\w+)?)*\\s+(.*)", 34);
    static final Pattern FROM_PATTERN = Pattern.compile("^\\s*FROM\\s+.*", 34);

    public static String getCountQuery(String query) {
        Object countQuery;
        Matcher selectMatcher = SELECT_PATTERN.matcher(query);
        if (selectMatcher.matches()) {
            String firstSelection = selectMatcher.group(1).trim();
            if (firstSelection.toLowerCase().startsWith("distinct ")) {
                String secondSelection = selectMatcher.group(2);
                if (secondSelection != null && !secondSelection.trim().isEmpty()) {
                    throw new PanacheQueryException("Count query not supported for select query: " + query);
                }
                countQuery = "SELECT COUNT(" + firstSelection + ") " + selectMatcher.group(3);
            } else {
                countQuery = "SELECT COUNT(*) " + selectMatcher.group(3);
            }
        } else if (FROM_PATTERN.matcher(query).matches()) {
            countQuery = "SELECT COUNT(*) " + query;
        } else {
            throw new PanacheQueryException("Count query not supported for select query: " + query);
        }
        String lcQuery = ((String)countQuery).toLowerCase();
        int orderByIndex = lcQuery.lastIndexOf(" order by ");
        if (orderByIndex != -1) {
            countQuery = ((String)countQuery).substring(0, orderByIndex);
        }
        return countQuery;
    }

    public static String getEntityName(Class<?> entityClass) {
        return entityClass.getName();
    }

    public static String createFindQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmed = ((String)query).replace('\n', ' ').replace('\r', ' ').trim();
        if (trimmed.isEmpty()) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ") || trimmedLc.startsWith("select ")) {
            return query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " " + (String)query;
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static boolean isNamedQuery(String query) {
        if (query == null || query.isEmpty()) {
            return false;
        }
        return query.charAt(0) == '#';
    }

    public static String createCountQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmed = ((String)query).trim();
        if (trimmed.isEmpty()) {
            return "SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ")) {
            return "SELECT COUNT(*) " + (String)query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static String createUpdateQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            throw new PanacheQueryException("Query string cannot be null");
        }
        String trimmed = ((String)query).trim();
        if (trimmed.isEmpty()) {
            throw new PanacheQueryException("Query string cannot be empty");
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("update from")) {
            return "update " + trimmed.substring(11);
        }
        if (trimmedLc.startsWith("update ")) {
            return query;
        }
        if (trimmedLc.startsWith("from ")) {
            return "UPDATE " + trimmed.substring(5);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        if (trimmedLc.startsWith("set ")) {
            return "UPDATE " + PanacheJpaUtil.getEntityName(entityClass) + " " + (String)query;
        }
        return "UPDATE " + PanacheJpaUtil.getEntityName(entityClass) + " SET " + (String)query;
    }

    public static String createDeleteQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmed = ((String)query).trim();
        if (trimmed.isEmpty()) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("delete ")) {
            return query;
        }
        if (trimmedLc.startsWith("from ")) {
            return "DELETE " + (String)query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static String toOrderBy(Sort sort) {
        if (sort == null) {
            return null;
        }
        if (sort.getColumns().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        for (int i = 0; i < sort.getColumns().size(); ++i) {
            Sort.Column column = (Sort.Column)sort.getColumns().get(i);
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append('`').append(PanacheJpaUtil.unquoteColumnName(column)).append('`');
            if (column.getDirection() != Sort.Direction.Ascending) {
                sb.append(" DESC");
            }
            if (column.getNullPrecedence() == null) continue;
            if (column.getNullPrecedence() == Sort.NullPrecedence.NULLS_FIRST) {
                sb.append(" NULLS FIRST");
                continue;
            }
            sb.append(" NULLS LAST");
        }
        return sb.toString();
    }

    private static String unquoteColumnName(Sort.Column column) {
        String columnName = column.getName();
        String unquotedColumnName = columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`' ? columnName.substring(1, columnName.length() - 1) : columnName;
        if (unquotedColumnName.indexOf(96) >= 0) {
            throw new PanacheQueryException("Sort column name cannot have backticks");
        }
        return unquotedColumnName;
    }
}

